/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v141.network.model.CrossOriginOpenerPolicyValue;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CrossOriginOpenerPolicyStatus {
    private final CrossOriginOpenerPolicyValue value;
    private final CrossOriginOpenerPolicyValue reportOnlyValue;
    private final Optional<String> reportingEndpoint;
    private final Optional<String> reportOnlyReportingEndpoint;

    public CrossOriginOpenerPolicyStatus(CrossOriginOpenerPolicyValue value, CrossOriginOpenerPolicyValue reportOnlyValue, Optional<String> reportingEndpoint, Optional<String> reportOnlyReportingEndpoint) {
        this.value = Objects.requireNonNull(value, "value is required");
        this.reportOnlyValue = Objects.requireNonNull(reportOnlyValue, "reportOnlyValue is required");
        this.reportingEndpoint = reportingEndpoint;
        this.reportOnlyReportingEndpoint = reportOnlyReportingEndpoint;
    }

    public CrossOriginOpenerPolicyValue getValue() {
        return this.value;
    }

    public CrossOriginOpenerPolicyValue getReportOnlyValue() {
        return this.reportOnlyValue;
    }

    public Optional<String> getReportingEndpoint() {
        return this.reportingEndpoint;
    }

    public Optional<String> getReportOnlyReportingEndpoint() {
        return this.reportOnlyReportingEndpoint;
    }

    private static CrossOriginOpenerPolicyStatus fromJson(JsonInput input) {
        CrossOriginOpenerPolicyValue value = null;
        CrossOriginOpenerPolicyValue reportOnlyValue = null;
        Optional<String> reportingEndpoint = Optional.empty();
        Optional<String> reportOnlyReportingEndpoint = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "value": {
                    value = (CrossOriginOpenerPolicyValue)((Object)input.read(CrossOriginOpenerPolicyValue.class));
                    continue block12;
                }
                case "reportOnlyValue": {
                    reportOnlyValue = (CrossOriginOpenerPolicyValue)((Object)input.read(CrossOriginOpenerPolicyValue.class));
                    continue block12;
                }
                case "reportingEndpoint": {
                    reportingEndpoint = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "reportOnlyReportingEndpoint": {
                    reportOnlyReportingEndpoint = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CrossOriginOpenerPolicyStatus(value, reportOnlyValue, reportingEndpoint, reportOnlyReportingEndpoint);
    }
}

