package org.openqa.selenium.devtools.v138.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ServiceWorkerRouterInfo {

    private final java.util.Optional<java.lang.Integer> ruleIdMatched;

    private final java.util.Optional<org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource> matchedSourceType;

    private final java.util.Optional<org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource> actualSourceType;

    public ServiceWorkerRouterInfo(java.util.Optional<java.lang.Integer> ruleIdMatched, java.util.Optional<org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource> matchedSourceType, java.util.Optional<org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource> actualSourceType) {
        this.ruleIdMatched = ruleIdMatched;
        this.matchedSourceType = matchedSourceType;
        this.actualSourceType = actualSourceType;
    }

    /**
     * ID of the rule matched. If there is a matched rule, this field will
     * be set, otherwiser no value will be set.
     */
    public java.util.Optional<java.lang.Integer> getRuleIdMatched() {
        return ruleIdMatched;
    }

    /**
     * The router source of the matched rule. If there is a matched rule, this
     * field will be set, otherwise no value will be set.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource> getMatchedSourceType() {
        return matchedSourceType;
    }

    /**
     * The actual router source used.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource> getActualSourceType() {
        return actualSourceType;
    }

    private static ServiceWorkerRouterInfo fromJson(JsonInput input) {
        java.util.Optional<java.lang.Integer> ruleIdMatched = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource> matchedSourceType = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource> actualSourceType = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "ruleIdMatched":
                    ruleIdMatched = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "matchedSourceType":
                    matchedSourceType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource.class));
                    break;
                case "actualSourceType":
                    actualSourceType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v138.network.model.ServiceWorkerRouterSource.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ServiceWorkerRouterInfo(ruleIdMatched, matchedSourceType, actualSourceType);
    }
}
