package org.openqa.selenium.devtools.v138.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum AttributionReportingAggregatableResult {

    SUCCESS("success"),
    INTERNALERROR("internalError"),
    NOCAPACITYFORATTRIBUTIONDESTINATION("noCapacityForAttributionDestination"),
    NOMATCHINGSOURCES("noMatchingSources"),
    EXCESSIVEATTRIBUTIONS("excessiveAttributions"),
    EXCESSIVEREPORTINGORIGINS("excessiveReportingOrigins"),
    NOHISTOGRAMS("noHistograms"),
    INSUFFICIENTBUDGET("insufficientBudget"),
    INSUFFICIENTNAMEDBUDGET("insufficientNamedBudget"),
    NOMATCHINGSOURCEFILTERDATA("noMatchingSourceFilterData"),
    NOTREGISTERED("notRegistered"),
    PROHIBITEDBYBROWSERPOLICY("prohibitedByBrowserPolicy"),
    DEDUPLICATED("deduplicated"),
    REPORTWINDOWPASSED("reportWindowPassed"),
    EXCESSIVEREPORTS("excessiveReports");

    private String value;

    AttributionReportingAggregatableResult(String value) {
        this.value = value;
    }

    public static AttributionReportingAggregatableResult fromString(String s) {
        return java.util.Arrays.stream(AttributionReportingAggregatableResult.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AttributionReportingAggregatableResult "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AttributionReportingAggregatableResult fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
