package org.openqa.selenium.devtools.v136.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue warns about third-party sites that are accessing cookies on the
 * current page, and have been permitted due to having a global metadata grant.
 * Note that in this context 'site' means eTLD+1. For example, if the URL
 * `https://example.test:80/web_page` was accessing cookies, the site reported
 * would be `example.test`.
 */
public class CookieDeprecationMetadataIssueDetails {

    private final java.util.List<java.lang.String> allowedSites;

    private final java.lang.Number optOutPercentage;

    private final java.lang.Boolean isOptOutTopLevel;

    private final org.openqa.selenium.devtools.v136.audits.model.CookieOperation operation;

    public CookieDeprecationMetadataIssueDetails(java.util.List<java.lang.String> allowedSites, java.lang.Number optOutPercentage, java.lang.Boolean isOptOutTopLevel, org.openqa.selenium.devtools.v136.audits.model.CookieOperation operation) {
        this.allowedSites = java.util.Objects.requireNonNull(allowedSites, "allowedSites is required");
        this.optOutPercentage = java.util.Objects.requireNonNull(optOutPercentage, "optOutPercentage is required");
        this.isOptOutTopLevel = java.util.Objects.requireNonNull(isOptOutTopLevel, "isOptOutTopLevel is required");
        this.operation = java.util.Objects.requireNonNull(operation, "operation is required");
    }

    public java.util.List<java.lang.String> getAllowedSites() {
        return allowedSites;
    }

    public java.lang.Number getOptOutPercentage() {
        return optOutPercentage;
    }

    public java.lang.Boolean getIsOptOutTopLevel() {
        return isOptOutTopLevel;
    }

    public org.openqa.selenium.devtools.v136.audits.model.CookieOperation getOperation() {
        return operation;
    }

    private static CookieDeprecationMetadataIssueDetails fromJson(JsonInput input) {
        java.util.List<java.lang.String> allowedSites = null;
        java.lang.Number optOutPercentage = 0;
        java.lang.Boolean isOptOutTopLevel = false;
        org.openqa.selenium.devtools.v136.audits.model.CookieOperation operation = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "allowedSites":
                    allowedSites = input.readArray(java.lang.String.class);
                    break;
                case "optOutPercentage":
                    optOutPercentage = input.nextNumber();
                    break;
                case "isOptOutTopLevel":
                    isOptOutTopLevel = input.nextBoolean();
                    break;
                case "operation":
                    operation = input.read(org.openqa.selenium.devtools.v136.audits.model.CookieOperation.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CookieDeprecationMetadataIssueDetails(allowedSites, optOutPercentage, isOptOutTopLevel, operation);
    }
}
