package org.openqa.selenium.devtools.v135.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Represents the cookie's 'Priority' status:
 * https://tools.ietf.org/html/draft-west-cookie-priority-00
 */
@org.openqa.selenium.Beta()
public enum CookiePriority {

    LOW("Low"), MEDIUM("Medium"), HIGH("High");

    private String value;

    CookiePriority(String value) {
        this.value = value;
    }

    public static CookiePriority fromString(String s) {
        return java.util.Arrays.stream(CookiePriority.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CookiePriority "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CookiePriority fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
