package org.openqa.selenium.devtools.v135.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when HTTP request has finished loading.
 */
public class LoadingFinished {

    private final org.openqa.selenium.devtools.v135.network.model.RequestId requestId;

    private final org.openqa.selenium.devtools.v135.network.model.MonotonicTime timestamp;

    private final java.lang.Number encodedDataLength;

    public LoadingFinished(org.openqa.selenium.devtools.v135.network.model.RequestId requestId, org.openqa.selenium.devtools.v135.network.model.MonotonicTime timestamp, java.lang.Number encodedDataLength) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.encodedDataLength = java.util.Objects.requireNonNull(encodedDataLength, "encodedDataLength is required");
    }

    /**
     * Request identifier.
     */
    public org.openqa.selenium.devtools.v135.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * Timestamp.
     */
    public org.openqa.selenium.devtools.v135.network.model.MonotonicTime getTimestamp() {
        return timestamp;
    }

    /**
     * Total number of bytes received for this request.
     */
    public java.lang.Number getEncodedDataLength() {
        return encodedDataLength;
    }

    private static LoadingFinished fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v135.network.model.RequestId requestId = null;
        org.openqa.selenium.devtools.v135.network.model.MonotonicTime timestamp = null;
        java.lang.Number encodedDataLength = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v135.network.model.RequestId.class);
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v135.network.model.MonotonicTime.class);
                    break;
                case "encodedDataLength":
                    encodedDataLength = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LoadingFinished(requestId, timestamp, encodedDataLength);
    }
}
