package org.openqa.selenium.devtools.v134.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The type of preloading attempted. It corresponds to
 * mojom::SpeculationAction (although PrefetchWithSubresources is omitted as it
 * isn't being used by clients).
 */
public enum SpeculationAction {

    PREFETCH("Prefetch"), PRERENDER("Prerender");

    private String value;

    SpeculationAction(String value) {
        this.value = value;
    }

    public static SpeculationAction fromString(String s) {
        return java.util.Arrays.stream(SpeculationAction.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SpeculationAction "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SpeculationAction fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
