package org.openqa.selenium.devtools.v134.layertree;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class LayerTree {

    public static class CompositingReasonsResponse {

        private final java.util.List<java.lang.String> compositingReasons;

        private final java.util.List<java.lang.String> compositingReasonIds;

        public CompositingReasonsResponse(java.util.List<java.lang.String> compositingReasons, java.util.List<java.lang.String> compositingReasonIds) {
            this.compositingReasons = java.util.Objects.requireNonNull(compositingReasons, "compositingReasons is required");
            this.compositingReasonIds = java.util.Objects.requireNonNull(compositingReasonIds, "compositingReasonIds is required");
        }

        /**
         * A list of strings specifying reasons for the given layer to become composited.
         */
        public java.util.List<java.lang.String> getCompositingReasons() {
            return compositingReasons;
        }

        /**
         * A list of strings specifying reason IDs for the given layer to become composited.
         */
        public java.util.List<java.lang.String> getCompositingReasonIds() {
            return compositingReasonIds;
        }

        private static CompositingReasonsResponse fromJson(JsonInput input) {
            java.util.List<java.lang.String> compositingReasons = null;
            java.util.List<java.lang.String> compositingReasonIds = null;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "compositingReasons":
                        compositingReasons = input.readArray(java.lang.String.class);
                        break;
                    case "compositingReasonIds":
                        compositingReasonIds = input.readArray(java.lang.String.class);
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new CompositingReasonsResponse(compositingReasons, compositingReasonIds);
        }
    }

    /**
     * Provides the reasons why the given layer was composited.
     */
    public static Command<org.openqa.selenium.devtools.v134.layertree.LayerTree.CompositingReasonsResponse> compositingReasons(org.openqa.selenium.devtools.v134.layertree.model.LayerId layerId) {
        java.util.Objects.requireNonNull(layerId, "layerId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("layerId", layerId);
        return new Command<>("LayerTree.compositingReasons", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v134.layertree.LayerTree.CompositingReasonsResponse.class));
    }

    /**
     * Disables compositing tree inspection.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("LayerTree.disable", Map.copyOf(params));
    }

    /**
     * Enables compositing tree inspection.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("LayerTree.enable", Map.copyOf(params));
    }

    /**
     * Returns the snapshot identifier.
     */
    public static Command<org.openqa.selenium.devtools.v134.layertree.model.SnapshotId> loadSnapshot(java.util.List<org.openqa.selenium.devtools.v134.layertree.model.PictureTile> tiles) {
        java.util.Objects.requireNonNull(tiles, "tiles is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("tiles", tiles);
        return new Command<>("LayerTree.loadSnapshot", Map.copyOf(params), ConverterFunctions.map("snapshotId", org.openqa.selenium.devtools.v134.layertree.model.SnapshotId.class));
    }

    /**
     * Returns the layer snapshot identifier.
     */
    public static Command<org.openqa.selenium.devtools.v134.layertree.model.SnapshotId> makeSnapshot(org.openqa.selenium.devtools.v134.layertree.model.LayerId layerId) {
        java.util.Objects.requireNonNull(layerId, "layerId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("layerId", layerId);
        return new Command<>("LayerTree.makeSnapshot", Map.copyOf(params), ConverterFunctions.map("snapshotId", org.openqa.selenium.devtools.v134.layertree.model.SnapshotId.class));
    }

    public static Command<java.util.List<org.openqa.selenium.devtools.v134.layertree.model.PaintProfile>> profileSnapshot(org.openqa.selenium.devtools.v134.layertree.model.SnapshotId snapshotId, java.util.Optional<java.lang.Integer> minRepeatCount, java.util.Optional<java.lang.Number> minDuration, java.util.Optional<org.openqa.selenium.devtools.v134.dom.model.Rect> clipRect) {
        java.util.Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("snapshotId", snapshotId);
        minRepeatCount.ifPresent(p -> params.put("minRepeatCount", p));
        minDuration.ifPresent(p -> params.put("minDuration", p));
        clipRect.ifPresent(p -> params.put("clipRect", p));
        return new Command<>("LayerTree.profileSnapshot", Map.copyOf(params), ConverterFunctions.map("timings", input -> input.readArray(org.openqa.selenium.devtools.v134.layertree.model.PaintProfile.class)));
    }

    /**
     * Releases layer snapshot captured by the back-end.
     */
    public static Command<Void> releaseSnapshot(org.openqa.selenium.devtools.v134.layertree.model.SnapshotId snapshotId) {
        java.util.Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("snapshotId", snapshotId);
        return new Command<>("LayerTree.releaseSnapshot", Map.copyOf(params));
    }

    /**
     * Replays the layer snapshot and returns the resulting bitmap.
     */
    public static Command<java.lang.String> replaySnapshot(org.openqa.selenium.devtools.v134.layertree.model.SnapshotId snapshotId, java.util.Optional<java.lang.Integer> fromStep, java.util.Optional<java.lang.Integer> toStep, java.util.Optional<java.lang.Number> scale) {
        java.util.Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("snapshotId", snapshotId);
        fromStep.ifPresent(p -> params.put("fromStep", p));
        toStep.ifPresent(p -> params.put("toStep", p));
        scale.ifPresent(p -> params.put("scale", p));
        return new Command<>("LayerTree.replaySnapshot", Map.copyOf(params), ConverterFunctions.map("dataURL", java.lang.String.class));
    }

    /**
     * Replays the layer snapshot and returns canvas log.
     */
    public static Command<java.util.List<java.util.Map<String, Object>>> snapshotCommandLog(org.openqa.selenium.devtools.v134.layertree.model.SnapshotId snapshotId) {
        java.util.Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("snapshotId", snapshotId);
        return new Command<>("LayerTree.snapshotCommandLog", Map.copyOf(params), ConverterFunctions.map("commandLog", input -> input.readArray(java.util.Map.class)));
    }

    public static Event<org.openqa.selenium.devtools.v134.layertree.model.LayerPainted> layerPainted() {
        return new Event<>("LayerTree.layerPainted", input -> input.read(org.openqa.selenium.devtools.v134.layertree.model.LayerPainted.class));
    }

    public static Event<java.util.List<org.openqa.selenium.devtools.v134.layertree.model.Layer>> layerTreeDidChange() {
        return new Event<>("LayerTree.layerTreeDidChange", ConverterFunctions.map("layers", input -> input.readArray(org.openqa.selenium.devtools.v134.layertree.model.Layer.class)));
    }
}
