package org.openqa.selenium.devtools.v134.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Represents the failure reason when a getUserInfo() call fails.
 * Should be updated alongside FederatedAuthUserInfoRequestResult in
 * third_party/blink/public/mojom/devtools/inspector_issue.mojom.
 */
public enum FederatedAuthUserInfoRequestIssueReason {

    NOTSAMEORIGIN("NotSameOrigin"),
    NOTIFRAME("NotIframe"),
    NOTPOTENTIALLYTRUSTWORTHY("NotPotentiallyTrustworthy"),
    NOAPIPERMISSION("NoApiPermission"),
    NOTSIGNEDINWITHIDP("NotSignedInWithIdp"),
    NOACCOUNTSHARINGPERMISSION("NoAccountSharingPermission"),
    INVALIDCONFIGORWELLKNOWN("InvalidConfigOrWellKnown"),
    INVALIDACCOUNTSRESPONSE("InvalidAccountsResponse"),
    NORETURNINGUSERFROMFETCHEDACCOUNTS("NoReturningUserFromFetchedAccounts");

    private String value;

    FederatedAuthUserInfoRequestIssueReason(String value) {
        this.value = value;
    }

    public static FederatedAuthUserInfoRequestIssueReason fromString(String s) {
        return java.util.Arrays.stream(FederatedAuthUserInfoRequestIssueReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within FederatedAuthUserInfoRequestIssueReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static FederatedAuthUserInfoRequestIssueReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
