package org.openqa.selenium.devtools.v133.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Emitted only when `page.interceptFileChooser` is enabled.
 */
public class FileChooserOpened {

    public enum Mode {

        SELECTSINGLE("selectSingle"), SELECTMULTIPLE("selectMultiple");

        private String value;

        Mode(String value) {
            this.value = value;
        }

        public static Mode fromString(String s) {
            return java.util.Arrays.stream(Mode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Mode "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Mode fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final org.openqa.selenium.devtools.v133.page.model.FrameId frameId;

    private final Mode mode;

    private final java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.BackendNodeId> backendNodeId;

    public FileChooserOpened(org.openqa.selenium.devtools.v133.page.model.FrameId frameId, Mode mode, java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.BackendNodeId> backendNodeId) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.mode = java.util.Objects.requireNonNull(mode, "mode is required");
        this.backendNodeId = backendNodeId;
    }

    /**
     * Id of the frame containing input node.
     */
    @Beta()
    public org.openqa.selenium.devtools.v133.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * Input mode.
     */
    public Mode getMode() {
        return mode;
    }

    /**
     * Input node id. Only present for file choosers opened via an `<input type="file">` element.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.BackendNodeId> getBackendNodeId() {
        return backendNodeId;
    }

    private static FileChooserOpened fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v133.page.model.FrameId frameId = null;
        Mode mode = null;
        java.util.Optional<org.openqa.selenium.devtools.v133.dom.model.BackendNodeId> backendNodeId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v133.page.model.FrameId.class);
                    break;
                case "mode":
                    mode = Mode.fromString(input.nextString());
                    break;
                case "backendNodeId":
                    backendNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v133.dom.model.BackendNodeId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FileChooserOpened(frameId, mode, backendNodeId);
    }
}
