/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.dom;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v133.dom.model.AttributeModified;
import org.openqa.selenium.devtools.v133.dom.model.AttributeRemoved;
import org.openqa.selenium.devtools.v133.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v133.dom.model.BoxModel;
import org.openqa.selenium.devtools.v133.dom.model.CSSComputedStyleProperty;
import org.openqa.selenium.devtools.v133.dom.model.CharacterDataModified;
import org.openqa.selenium.devtools.v133.dom.model.ChildNodeCountUpdated;
import org.openqa.selenium.devtools.v133.dom.model.ChildNodeInserted;
import org.openqa.selenium.devtools.v133.dom.model.ChildNodeRemoved;
import org.openqa.selenium.devtools.v133.dom.model.DetachedElementInfo;
import org.openqa.selenium.devtools.v133.dom.model.DistributedNodesUpdated;
import org.openqa.selenium.devtools.v133.dom.model.LogicalAxes;
import org.openqa.selenium.devtools.v133.dom.model.Node;
import org.openqa.selenium.devtools.v133.dom.model.NodeId;
import org.openqa.selenium.devtools.v133.dom.model.PhysicalAxes;
import org.openqa.selenium.devtools.v133.dom.model.PseudoElementAdded;
import org.openqa.selenium.devtools.v133.dom.model.PseudoElementRemoved;
import org.openqa.selenium.devtools.v133.dom.model.Quad;
import org.openqa.selenium.devtools.v133.dom.model.Rect;
import org.openqa.selenium.devtools.v133.dom.model.ScrollableFlagUpdated;
import org.openqa.selenium.devtools.v133.dom.model.SetChildNodes;
import org.openqa.selenium.devtools.v133.dom.model.ShadowRootPopped;
import org.openqa.selenium.devtools.v133.dom.model.ShadowRootPushed;
import org.openqa.selenium.devtools.v133.page.model.FrameId;
import org.openqa.selenium.devtools.v133.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v133.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v133.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.v133.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class DOM {
    @Beta
    public static Command<List<String>> collectClassNamesFromSubtree(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("DOM.collectClassNamesFromSubtree", Map.copyOf(params), ConverterFunctions.map((String)"classNames", input -> input.readArray(String.class)));
    }

    @Beta
    public static Command<NodeId> copyTo(NodeId nodeId, NodeId targetNodeId, Optional<NodeId> insertBeforeNodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(targetNodeId, "targetNodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        params.put("targetNodeId", targetNodeId);
        insertBeforeNodeId.ifPresent(p -> params.put("insertBeforeNodeId", (NodeId)p));
        return new Command("DOM.copyTo", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Command<Node> describeNode(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Integer> depth, Optional<Boolean> pierce) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        depth.ifPresent(p -> params.put("depth", p));
        pierce.ifPresent(p -> params.put("pierce", p));
        return new Command("DOM.describeNode", Map.copyOf(params), ConverterFunctions.map((String)"node", Node.class));
    }

    public static Command<Void> scrollIntoViewIfNeeded(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Rect> rect) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        rect.ifPresent(p -> params.put("rect", p));
        return new Command("DOM.scrollIntoViewIfNeeded", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOM.disable", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> discardSearchResults(String searchId) {
        Objects.requireNonNull(searchId, "searchId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("searchId", searchId);
        return new Command("DOM.discardSearchResults", Map.copyOf(params));
    }

    public static Command<Void> enable(Optional<EnableIncludeWhitespace> includeWhitespace) {
        LinkedHashMap params = new LinkedHashMap();
        includeWhitespace.ifPresent(p -> params.put("includeWhitespace", p));
        return new Command("DOM.enable", Map.copyOf(params));
    }

    public static Command<Void> focus(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command("DOM.focus", Map.copyOf(params));
    }

    public static Command<List<String>> getAttributes(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("DOM.getAttributes", Map.copyOf(params), ConverterFunctions.map((String)"attributes", input -> input.readArray(String.class)));
    }

    public static Command<BoxModel> getBoxModel(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command("DOM.getBoxModel", Map.copyOf(params), ConverterFunctions.map((String)"model", BoxModel.class));
    }

    @Beta
    public static Command<List<Quad>> getContentQuads(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command("DOM.getContentQuads", Map.copyOf(params), ConverterFunctions.map((String)"quads", input -> input.readArray(Quad.class)));
    }

    public static Command<Node> getDocument(Optional<Integer> depth, Optional<Boolean> pierce) {
        LinkedHashMap params = new LinkedHashMap();
        depth.ifPresent(p -> params.put("depth", p));
        pierce.ifPresent(p -> params.put("pierce", p));
        return new Command("DOM.getDocument", Map.copyOf(params), ConverterFunctions.map((String)"root", Node.class));
    }

    @Deprecated
    public static Command<List<Node>> getFlattenedDocument(Optional<Integer> depth, Optional<Boolean> pierce) {
        LinkedHashMap params = new LinkedHashMap();
        depth.ifPresent(p -> params.put("depth", p));
        pierce.ifPresent(p -> params.put("pierce", p));
        return new Command("DOM.getFlattenedDocument", Map.copyOf(params), ConverterFunctions.map((String)"nodes", input -> input.readArray(Node.class)));
    }

    @Beta
    public static Command<List<NodeId>> getNodesForSubtreeByStyle(NodeId nodeId, List<CSSComputedStyleProperty> computedStyles, Optional<Boolean> pierce) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(computedStyles, "computedStyles is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("computedStyles", computedStyles);
        pierce.ifPresent(p -> params.put("pierce", p));
        return new Command("DOM.getNodesForSubtreeByStyle", Map.copyOf(params), ConverterFunctions.map((String)"nodeIds", input -> input.readArray(NodeId.class)));
    }

    public static Command<GetNodeForLocationResponse> getNodeForLocation(Integer x, Integer y, Optional<Boolean> includeUserAgentShadowDOM, Optional<Boolean> ignorePointerEventsNone) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("x", x);
        params.put("y", y);
        includeUserAgentShadowDOM.ifPresent(p -> params.put("includeUserAgentShadowDOM", (Integer)p));
        ignorePointerEventsNone.ifPresent(p -> params.put("ignorePointerEventsNone", (Integer)p));
        return new Command("DOM.getNodeForLocation", Map.copyOf(params), input -> (GetNodeForLocationResponse)input.read(GetNodeForLocationResponse.class));
    }

    public static Command<String> getOuterHTML(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command("DOM.getOuterHTML", Map.copyOf(params), ConverterFunctions.map((String)"outerHTML", String.class));
    }

    @Beta
    public static Command<NodeId> getRelayoutBoundary(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("DOM.getRelayoutBoundary", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> getSearchResults(String searchId, Integer fromIndex, Integer toIndex) {
        Objects.requireNonNull(searchId, "searchId is required");
        Objects.requireNonNull(fromIndex, "fromIndex is required");
        Objects.requireNonNull(toIndex, "toIndex is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("searchId", searchId);
        params.put("fromIndex", fromIndex);
        params.put("toIndex", toIndex);
        return new Command("DOM.getSearchResults", Map.copyOf(params), ConverterFunctions.map((String)"nodeIds", input -> input.readArray(NodeId.class)));
    }

    public static Command<Void> hideHighlight() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOM.hideHighlight", Map.copyOf(params));
    }

    public static Command<Void> highlightNode() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOM.highlightNode", Map.copyOf(params));
    }

    public static Command<Void> highlightRect() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOM.highlightRect", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> markUndoableState() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOM.markUndoableState", Map.copyOf(params));
    }

    public static Command<NodeId> moveTo(NodeId nodeId, NodeId targetNodeId, Optional<NodeId> insertBeforeNodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(targetNodeId, "targetNodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        params.put("targetNodeId", targetNodeId);
        insertBeforeNodeId.ifPresent(p -> params.put("insertBeforeNodeId", (NodeId)p));
        return new Command("DOM.moveTo", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    @Beta
    public static Command<PerformSearchResponse> performSearch(String query, Optional<Boolean> includeUserAgentShadowDOM) {
        Objects.requireNonNull(query, "query is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("query", query);
        includeUserAgentShadowDOM.ifPresent(p -> params.put("includeUserAgentShadowDOM", (String)p));
        return new Command("DOM.performSearch", Map.copyOf(params), input -> (PerformSearchResponse)input.read(PerformSearchResponse.class));
    }

    @Beta
    public static Command<NodeId> pushNodeByPathToFrontend(String path) {
        Objects.requireNonNull(path, "path is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("path", path);
        return new Command("DOM.pushNodeByPathToFrontend", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> pushNodesByBackendIdsToFrontend(List<BackendNodeId> backendNodeIds) {
        Objects.requireNonNull(backendNodeIds, "backendNodeIds is required");
        LinkedHashMap<String, List<BackendNodeId>> params = new LinkedHashMap<String, List<BackendNodeId>>();
        params.put("backendNodeIds", backendNodeIds);
        return new Command("DOM.pushNodesByBackendIdsToFrontend", Map.copyOf(params), ConverterFunctions.map((String)"nodeIds", input -> input.readArray(NodeId.class)));
    }

    public static Command<NodeId> querySelector(NodeId nodeId, String selector) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(selector, "selector is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("selector", selector);
        return new Command("DOM.querySelector", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Command<List<NodeId>> querySelectorAll(NodeId nodeId, String selector) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(selector, "selector is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("selector", selector);
        return new Command("DOM.querySelectorAll", Map.copyOf(params), ConverterFunctions.map((String)"nodeIds", input -> input.readArray(NodeId.class)));
    }

    @Beta
    public static Command<List<NodeId>> getTopLayerElements() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOM.getTopLayerElements", Map.copyOf(params), ConverterFunctions.map((String)"nodeIds", input -> input.readArray(NodeId.class)));
    }

    @Beta
    public static Command<NodeId> getElementByRelation(NodeId nodeId, GetElementByRelationRelation relation) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(relation, "relation is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("relation", (Object)relation);
        return new Command("DOM.getElementByRelation", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    @Beta
    public static Command<Void> redo() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOM.redo", Map.copyOf(params));
    }

    public static Command<Void> removeAttribute(NodeId nodeId, String name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("name", name);
        return new Command("DOM.removeAttribute", Map.copyOf(params));
    }

    public static Command<Void> removeNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("DOM.removeNode", Map.copyOf(params));
    }

    public static Command<Void> requestChildNodes(NodeId nodeId, Optional<Integer> depth, Optional<Boolean> pierce) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        depth.ifPresent(p -> params.put("depth", (NodeId)p));
        pierce.ifPresent(p -> params.put("pierce", (NodeId)p));
        return new Command("DOM.requestChildNodes", Map.copyOf(params));
    }

    public static Command<NodeId> requestNode(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("objectId", objectId);
        return new Command("DOM.requestNode", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Command<RemoteObject> resolveNode(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<String> objectGroup, Optional<ExecutionContextId> executionContextId) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectGroup.ifPresent(p -> params.put("objectGroup", p));
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        return new Command("DOM.resolveNode", Map.copyOf(params), ConverterFunctions.map((String)"object", RemoteObject.class));
    }

    public static Command<Void> setAttributeValue(NodeId nodeId, String name, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("name", name);
        params.put("value", value);
        return new Command("DOM.setAttributeValue", Map.copyOf(params));
    }

    public static Command<Void> setAttributesAsText(NodeId nodeId, String text, Optional<String> name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("text", text);
        name.ifPresent(p -> params.put("name", p));
        return new Command("DOM.setAttributesAsText", Map.copyOf(params));
    }

    public static Command<Void> setFileInputFiles(List<String> files, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        Objects.requireNonNull(files, "files is required");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("files", files);
        nodeId.ifPresent(p -> params.put("nodeId", (List<String>)p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", (List<String>)p));
        objectId.ifPresent(p -> params.put("objectId", (List<String>)p));
        return new Command("DOM.setFileInputFiles", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setNodeStackTracesEnabled(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enable", enable);
        return new Command("DOM.setNodeStackTracesEnabled", Map.copyOf(params));
    }

    @Beta
    public static Command<StackTrace> getNodeStackTraces(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("DOM.getNodeStackTraces", Map.copyOf(params), ConverterFunctions.map((String)"creation", StackTrace.class));
    }

    @Beta
    public static Command<String> getFileInfo(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("objectId", objectId);
        return new Command("DOM.getFileInfo", Map.copyOf(params), ConverterFunctions.map((String)"path", String.class));
    }

    @Beta
    public static Command<List<DetachedElementInfo>> getDetachedDomNodes() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOM.getDetachedDomNodes", Map.copyOf(params), ConverterFunctions.map((String)"detachedNodes", input -> input.readArray(DetachedElementInfo.class)));
    }

    @Beta
    public static Command<Void> setInspectedNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("DOM.setInspectedNode", Map.copyOf(params));
    }

    public static Command<NodeId> setNodeName(NodeId nodeId, String name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("name", name);
        return new Command("DOM.setNodeName", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Command<Void> setNodeValue(NodeId nodeId, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("value", value);
        return new Command("DOM.setNodeValue", Map.copyOf(params));
    }

    public static Command<Void> setOuterHTML(NodeId nodeId, String outerHTML) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(outerHTML, "outerHTML is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("nodeId", nodeId);
        params.put("outerHTML", outerHTML);
        return new Command("DOM.setOuterHTML", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> undo() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOM.undo", Map.copyOf(params));
    }

    @Beta
    public static Command<GetFrameOwnerResponse> getFrameOwner(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        return new Command("DOM.getFrameOwner", Map.copyOf(params), input -> (GetFrameOwnerResponse)input.read(GetFrameOwnerResponse.class));
    }

    @Beta
    public static Command<NodeId> getContainerForNode(NodeId nodeId, Optional<String> containerName, Optional<PhysicalAxes> physicalAxes, Optional<LogicalAxes> logicalAxes, Optional<Boolean> queriesScrollState) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        containerName.ifPresent(p -> params.put("containerName", (NodeId)p));
        physicalAxes.ifPresent(p -> params.put("physicalAxes", (NodeId)p));
        logicalAxes.ifPresent(p -> params.put("logicalAxes", (NodeId)p));
        queriesScrollState.ifPresent(p -> params.put("queriesScrollState", (NodeId)p));
        return new Command("DOM.getContainerForNode", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> getQueryingDescendantsForContainer(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command("DOM.getQueryingDescendantsForContainer", Map.copyOf(params), ConverterFunctions.map((String)"nodeIds", input -> input.readArray(NodeId.class)));
    }

    @Beta
    public static Command<NodeId> getAnchorElement(NodeId nodeId, Optional<String> anchorSpecifier) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        anchorSpecifier.ifPresent(p -> params.put("anchorSpecifier", (NodeId)p));
        return new Command("DOM.getAnchorElement", Map.copyOf(params), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Event<AttributeModified> attributeModified() {
        return new Event("DOM.attributeModified", input -> (AttributeModified)input.read(AttributeModified.class));
    }

    public static Event<AttributeRemoved> attributeRemoved() {
        return new Event("DOM.attributeRemoved", input -> (AttributeRemoved)input.read(AttributeRemoved.class));
    }

    public static Event<CharacterDataModified> characterDataModified() {
        return new Event("DOM.characterDataModified", input -> (CharacterDataModified)input.read(CharacterDataModified.class));
    }

    public static Event<ChildNodeCountUpdated> childNodeCountUpdated() {
        return new Event("DOM.childNodeCountUpdated", input -> (ChildNodeCountUpdated)input.read(ChildNodeCountUpdated.class));
    }

    public static Event<ChildNodeInserted> childNodeInserted() {
        return new Event("DOM.childNodeInserted", input -> (ChildNodeInserted)input.read(ChildNodeInserted.class));
    }

    public static Event<ChildNodeRemoved> childNodeRemoved() {
        return new Event("DOM.childNodeRemoved", input -> (ChildNodeRemoved)input.read(ChildNodeRemoved.class));
    }

    public static Event<DistributedNodesUpdated> distributedNodesUpdated() {
        return new Event("DOM.distributedNodesUpdated", input -> (DistributedNodesUpdated)input.read(DistributedNodesUpdated.class));
    }

    public static Event<Void> documentUpdated() {
        return new Event("DOM.documentUpdated", ConverterFunctions.empty());
    }

    public static Event<List<NodeId>> inlineStyleInvalidated() {
        return new Event("DOM.inlineStyleInvalidated", ConverterFunctions.map((String)"nodeIds", input -> input.readArray(NodeId.class)));
    }

    public static Event<PseudoElementAdded> pseudoElementAdded() {
        return new Event("DOM.pseudoElementAdded", input -> (PseudoElementAdded)input.read(PseudoElementAdded.class));
    }

    public static Event<Void> topLayerElementsUpdated() {
        return new Event("DOM.topLayerElementsUpdated", ConverterFunctions.empty());
    }

    public static Event<ScrollableFlagUpdated> scrollableFlagUpdated() {
        return new Event("DOM.scrollableFlagUpdated", input -> (ScrollableFlagUpdated)input.read(ScrollableFlagUpdated.class));
    }

    public static Event<PseudoElementRemoved> pseudoElementRemoved() {
        return new Event("DOM.pseudoElementRemoved", input -> (PseudoElementRemoved)input.read(PseudoElementRemoved.class));
    }

    public static Event<SetChildNodes> setChildNodes() {
        return new Event("DOM.setChildNodes", input -> (SetChildNodes)input.read(SetChildNodes.class));
    }

    public static Event<ShadowRootPopped> shadowRootPopped() {
        return new Event("DOM.shadowRootPopped", input -> (ShadowRootPopped)input.read(ShadowRootPopped.class));
    }

    public static Event<ShadowRootPushed> shadowRootPushed() {
        return new Event("DOM.shadowRootPushed", input -> (ShadowRootPushed)input.read(ShadowRootPushed.class));
    }

    public static class GetFrameOwnerResponse {
        private final BackendNodeId backendNodeId;
        private final Optional<NodeId> nodeId;

        public GetFrameOwnerResponse(BackendNodeId backendNodeId, Optional<NodeId> nodeId) {
            this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
            this.nodeId = nodeId;
        }

        public BackendNodeId getBackendNodeId() {
            return this.backendNodeId;
        }

        public Optional<NodeId> getNodeId() {
            return this.nodeId;
        }

        private static GetFrameOwnerResponse fromJson(JsonInput input) {
            BackendNodeId backendNodeId = null;
            Optional<NodeId> nodeId = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backendNodeId": {
                        backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                        continue block8;
                    }
                    case "nodeId": {
                        nodeId = Optional.ofNullable((NodeId)input.read(NodeId.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetFrameOwnerResponse(backendNodeId, nodeId);
        }
    }

    public static class PerformSearchResponse {
        private final String searchId;
        private final Integer resultCount;

        public PerformSearchResponse(String searchId, Integer resultCount) {
            this.searchId = Objects.requireNonNull(searchId, "searchId is required");
            this.resultCount = Objects.requireNonNull(resultCount, "resultCount is required");
        }

        public String getSearchId() {
            return this.searchId;
        }

        public Integer getResultCount() {
            return this.resultCount;
        }

        private static PerformSearchResponse fromJson(JsonInput input) {
            String searchId = null;
            Integer resultCount = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "searchId": {
                        searchId = input.nextString();
                        continue block8;
                    }
                    case "resultCount": {
                        resultCount = input.nextNumber().intValue();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new PerformSearchResponse(searchId, resultCount);
        }
    }

    public static class GetNodeForLocationResponse {
        private final BackendNodeId backendNodeId;
        private final FrameId frameId;
        private final Optional<NodeId> nodeId;

        public GetNodeForLocationResponse(BackendNodeId backendNodeId, FrameId frameId, Optional<NodeId> nodeId) {
            this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
            this.frameId = Objects.requireNonNull(frameId, "frameId is required");
            this.nodeId = nodeId;
        }

        public BackendNodeId getBackendNodeId() {
            return this.backendNodeId;
        }

        public FrameId getFrameId() {
            return this.frameId;
        }

        public Optional<NodeId> getNodeId() {
            return this.nodeId;
        }

        private static GetNodeForLocationResponse fromJson(JsonInput input) {
            BackendNodeId backendNodeId = null;
            FrameId frameId = null;
            Optional<NodeId> nodeId = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backendNodeId": {
                        backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                        continue block10;
                    }
                    case "frameId": {
                        frameId = (FrameId)input.read(FrameId.class);
                        continue block10;
                    }
                    case "nodeId": {
                        nodeId = Optional.ofNullable((NodeId)input.read(NodeId.class));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetNodeForLocationResponse(backendNodeId, frameId, nodeId);
        }
    }

    public static enum GetElementByRelationRelation {
        POPOVERTARGET("PopoverTarget");

        private String value;

        private GetElementByRelationRelation(String value) {
            this.value = value;
        }

        public static GetElementByRelationRelation fromString(String s) {
            return Arrays.stream(GetElementByRelationRelation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within GetElementByRelationRelation "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static GetElementByRelationRelation fromJson(JsonInput input) {
            return GetElementByRelationRelation.fromString(input.nextString());
        }
    }

    public static enum EnableIncludeWhitespace {
        NONE("none"),
        ALL("all");

        private String value;

        private EnableIncludeWhitespace(String value) {
            this.value = value;
        }

        public static EnableIncludeWhitespace fromString(String s) {
            return Arrays.stream(EnableIncludeWhitespace.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within EnableIncludeWhitespace "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static EnableIncludeWhitespace fromJson(JsonInput input) {
            return EnableIncludeWhitespace.fromString(input.nextString());
        }
    }
}

