package org.openqa.selenium.devtools.v132.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class Screenshot {

    private final org.openqa.selenium.devtools.v132.page.model.ImageResource image;

    private final java.lang.String formFactor;

    private final java.util.Optional<java.lang.String> label;

    public Screenshot(org.openqa.selenium.devtools.v132.page.model.ImageResource image, java.lang.String formFactor, java.util.Optional<java.lang.String> label) {
        this.image = java.util.Objects.requireNonNull(image, "image is required");
        this.formFactor = java.util.Objects.requireNonNull(formFactor, "formFactor is required");
        this.label = label;
    }

    public org.openqa.selenium.devtools.v132.page.model.ImageResource getImage() {
        return image;
    }

    public java.lang.String getFormFactor() {
        return formFactor;
    }

    public java.util.Optional<java.lang.String> getLabel() {
        return label;
    }

    private static Screenshot fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v132.page.model.ImageResource image = null;
        java.lang.String formFactor = null;
        java.util.Optional<java.lang.String> label = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "image":
                    image = input.read(org.openqa.selenium.devtools.v132.page.model.ImageResource.class);
                    break;
                case "formFactor":
                    formFactor = input.nextString();
                    break;
                case "label":
                    label = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Screenshot(image, formFactor, label);
    }
}
