package org.openqa.selenium.devtools.v132.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class FlexNodeHighlightConfig {

    private final org.openqa.selenium.devtools.v132.overlay.model.FlexContainerHighlightConfig flexContainerHighlightConfig;

    private final org.openqa.selenium.devtools.v132.dom.model.NodeId nodeId;

    public FlexNodeHighlightConfig(org.openqa.selenium.devtools.v132.overlay.model.FlexContainerHighlightConfig flexContainerHighlightConfig, org.openqa.selenium.devtools.v132.dom.model.NodeId nodeId) {
        this.flexContainerHighlightConfig = java.util.Objects.requireNonNull(flexContainerHighlightConfig, "flexContainerHighlightConfig is required");
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
    }

    /**
     * A descriptor for the highlight appearance of flex containers.
     */
    public org.openqa.selenium.devtools.v132.overlay.model.FlexContainerHighlightConfig getFlexContainerHighlightConfig() {
        return flexContainerHighlightConfig;
    }

    /**
     * Identifier of the node to highlight.
     */
    public org.openqa.selenium.devtools.v132.dom.model.NodeId getNodeId() {
        return nodeId;
    }

    private static FlexNodeHighlightConfig fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v132.overlay.model.FlexContainerHighlightConfig flexContainerHighlightConfig = null;
        org.openqa.selenium.devtools.v132.dom.model.NodeId nodeId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "flexContainerHighlightConfig":
                    flexContainerHighlightConfig = input.read(org.openqa.selenium.devtools.v132.overlay.model.FlexContainerHighlightConfig.class);
                    break;
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v132.dom.model.NodeId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FlexNodeHighlightConfig(flexContainerHighlightConfig, nodeId);
    }
}
