/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.pwa;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v131.pwa.model.DisplayMode;
import org.openqa.selenium.devtools.v131.pwa.model.FileHandler;
import org.openqa.selenium.devtools.v131.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PWA {
    public static Command<GetOsAppStateResponse> getOsAppState(String manifestId) {
        Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("manifestId", manifestId);
        return new Command("PWA.getOsAppState", Map.copyOf(params), input -> (GetOsAppStateResponse)input.read(GetOsAppStateResponse.class));
    }

    public static Command<Void> install(String manifestId, Optional<String> installUrlOrBundleUrl) {
        Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("manifestId", manifestId);
        installUrlOrBundleUrl.ifPresent(p -> params.put("installUrlOrBundleUrl", (String)p));
        return new Command("PWA.install", Map.copyOf(params));
    }

    public static Command<Void> uninstall(String manifestId) {
        Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("manifestId", manifestId);
        return new Command("PWA.uninstall", Map.copyOf(params));
    }

    public static Command<TargetID> launch(String manifestId, Optional<String> url) {
        Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("manifestId", manifestId);
        url.ifPresent(p -> params.put("url", (String)p));
        return new Command("PWA.launch", Map.copyOf(params), ConverterFunctions.map((String)"targetId", TargetID.class));
    }

    public static Command<List<TargetID>> launchFilesInApp(String manifestId, List<String> files) {
        Objects.requireNonNull(manifestId, "manifestId is required");
        Objects.requireNonNull(files, "files is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("manifestId", manifestId);
        params.put("files", files);
        return new Command("PWA.launchFilesInApp", Map.copyOf(params), ConverterFunctions.map((String)"targetIds", input -> input.readArray(TargetID.class)));
    }

    public static Command<Void> openCurrentPageInApp(String manifestId) {
        Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("manifestId", manifestId);
        return new Command("PWA.openCurrentPageInApp", Map.copyOf(params));
    }

    public static Command<Void> changeAppUserSettings(String manifestId, Optional<Boolean> linkCapturing, Optional<DisplayMode> displayMode) {
        Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("manifestId", manifestId);
        linkCapturing.ifPresent(p -> params.put("linkCapturing", (String)p));
        displayMode.ifPresent(p -> params.put("displayMode", (String)p));
        return new Command("PWA.changeAppUserSettings", Map.copyOf(params));
    }

    public static class GetOsAppStateResponse {
        private final Integer badgeCount;
        private final List<FileHandler> fileHandlers;

        public GetOsAppStateResponse(Integer badgeCount, List<FileHandler> fileHandlers) {
            this.badgeCount = Objects.requireNonNull(badgeCount, "badgeCount is required");
            this.fileHandlers = Objects.requireNonNull(fileHandlers, "fileHandlers is required");
        }

        public Integer getBadgeCount() {
            return this.badgeCount;
        }

        public List<FileHandler> getFileHandlers() {
            return this.fileHandlers;
        }

        private static GetOsAppStateResponse fromJson(JsonInput input) {
            Integer badgeCount = 0;
            List fileHandlers = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "badgeCount": {
                        badgeCount = input.nextNumber().intValue();
                        continue block8;
                    }
                    case "fileHandlers": {
                        fileHandlers = input.readArray(FileHandler.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetOsAppStateResponse(badgeCount, fileHandlers);
        }
    }
}

