package org.openqa.selenium.devtools.v130.deviceaccess.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A device id.
 */
public class DeviceId {

    private final java.lang.String deviceId;

    public DeviceId(java.lang.String deviceId) {
        this.deviceId = java.util.Objects.requireNonNull(deviceId, "Missing value for DeviceId");
    }

    private static DeviceId fromJson(JsonInput input) {
        return new DeviceId(input.nextString());
    }

    public String toJson() {
        return deviceId.toString();
    }

    public String toString() {
        return deviceId.toString();
    }
}
