/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v129.network.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class WebSocketFrame {
    private final Number opcode;
    private final Boolean mask;
    private final String payloadData;

    public WebSocketFrame(Number opcode, Boolean mask, String payloadData) {
        this.opcode = Objects.requireNonNull(opcode, "opcode is required");
        this.mask = Objects.requireNonNull(mask, "mask is required");
        this.payloadData = Objects.requireNonNull(payloadData, "payloadData is required");
    }

    public Number getOpcode() {
        return this.opcode;
    }

    public Boolean getMask() {
        return this.mask;
    }

    public String getPayloadData() {
        return this.payloadData;
    }

    private static WebSocketFrame fromJson(JsonInput input) {
        Number opcode = 0;
        Boolean mask = false;
        String payloadData = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "opcode": {
                    opcode = input.nextNumber();
                    continue block10;
                }
                case "mask": {
                    mask = input.nextBoolean();
                    continue block10;
                }
                case "payloadData": {
                    payloadData = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WebSocketFrame(opcode, mask, payloadData);
    }
}

