package org.openqa.selenium.devtools.v129.tracing.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class TraceConfig {

    public enum RecordMode {

        RECORDUNTILFULL("recordUntilFull"), RECORDCONTINUOUSLY("recordContinuously"), RECORDASMUCHASPOSSIBLE("recordAsMuchAsPossible"), ECHOTOCONSOLE("echoToConsole");

        private String value;

        RecordMode(String value) {
            this.value = value;
        }

        public static RecordMode fromString(String s) {
            return java.util.Arrays.stream(RecordMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within RecordMode "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static RecordMode fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final java.util.Optional<RecordMode> recordMode;

    private final java.util.Optional<java.lang.Number> traceBufferSizeInKb;

    private final java.util.Optional<java.lang.Boolean> enableSampling;

    private final java.util.Optional<java.lang.Boolean> enableSystrace;

    private final java.util.Optional<java.lang.Boolean> enableArgumentFilter;

    private final java.util.Optional<java.util.List<java.lang.String>> includedCategories;

    private final java.util.Optional<java.util.List<java.lang.String>> excludedCategories;

    private final java.util.Optional<java.util.List<java.lang.String>> syntheticDelays;

    private final java.util.Optional<org.openqa.selenium.devtools.v129.tracing.model.MemoryDumpConfig> memoryDumpConfig;

    public TraceConfig(java.util.Optional<RecordMode> recordMode, java.util.Optional<java.lang.Number> traceBufferSizeInKb, java.util.Optional<java.lang.Boolean> enableSampling, java.util.Optional<java.lang.Boolean> enableSystrace, java.util.Optional<java.lang.Boolean> enableArgumentFilter, java.util.Optional<java.util.List<java.lang.String>> includedCategories, java.util.Optional<java.util.List<java.lang.String>> excludedCategories, java.util.Optional<java.util.List<java.lang.String>> syntheticDelays, java.util.Optional<org.openqa.selenium.devtools.v129.tracing.model.MemoryDumpConfig> memoryDumpConfig) {
        this.recordMode = recordMode;
        this.traceBufferSizeInKb = traceBufferSizeInKb;
        this.enableSampling = enableSampling;
        this.enableSystrace = enableSystrace;
        this.enableArgumentFilter = enableArgumentFilter;
        this.includedCategories = includedCategories;
        this.excludedCategories = excludedCategories;
        this.syntheticDelays = syntheticDelays;
        this.memoryDumpConfig = memoryDumpConfig;
    }

    /**
     * Controls how the trace buffer stores data.
     */
    @Beta()
    public java.util.Optional<RecordMode> getRecordMode() {
        return recordMode;
    }

    /**
     * Size of the trace buffer in kilobytes. If not specified or zero is passed, a default value
     * of 200 MB would be used.
     */
    @Beta()
    public java.util.Optional<java.lang.Number> getTraceBufferSizeInKb() {
        return traceBufferSizeInKb;
    }

    /**
     * Turns on JavaScript stack sampling.
     */
    @Beta()
    public java.util.Optional<java.lang.Boolean> getEnableSampling() {
        return enableSampling;
    }

    /**
     * Turns on system tracing.
     */
    @Beta()
    public java.util.Optional<java.lang.Boolean> getEnableSystrace() {
        return enableSystrace;
    }

    /**
     * Turns on argument filter.
     */
    @Beta()
    public java.util.Optional<java.lang.Boolean> getEnableArgumentFilter() {
        return enableArgumentFilter;
    }

    /**
     * Included category filters.
     */
    public java.util.Optional<java.util.List<java.lang.String>> getIncludedCategories() {
        return includedCategories;
    }

    /**
     * Excluded category filters.
     */
    public java.util.Optional<java.util.List<java.lang.String>> getExcludedCategories() {
        return excludedCategories;
    }

    /**
     * Configuration to synthesize the delays in tracing.
     */
    @Beta()
    public java.util.Optional<java.util.List<java.lang.String>> getSyntheticDelays() {
        return syntheticDelays;
    }

    /**
     * Configuration for memory dump triggers. Used only when "memory-infra" category is enabled.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v129.tracing.model.MemoryDumpConfig> getMemoryDumpConfig() {
        return memoryDumpConfig;
    }

    private static TraceConfig fromJson(JsonInput input) {
        java.util.Optional<RecordMode> recordMode = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> traceBufferSizeInKb = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> enableSampling = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> enableSystrace = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> enableArgumentFilter = java.util.Optional.empty();
        java.util.Optional<java.util.List<java.lang.String>> includedCategories = java.util.Optional.empty();
        java.util.Optional<java.util.List<java.lang.String>> excludedCategories = java.util.Optional.empty();
        java.util.Optional<java.util.List<java.lang.String>> syntheticDelays = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v129.tracing.model.MemoryDumpConfig> memoryDumpConfig = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "recordMode":
                    recordMode = java.util.Optional.ofNullable(RecordMode.fromString(input.nextString()));
                    break;
                case "traceBufferSizeInKb":
                    traceBufferSizeInKb = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "enableSampling":
                    enableSampling = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "enableSystrace":
                    enableSystrace = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "enableArgumentFilter":
                    enableArgumentFilter = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "includedCategories":
                    includedCategories = java.util.Optional.ofNullable(input.readArray(java.lang.String.class));
                    break;
                case "excludedCategories":
                    excludedCategories = java.util.Optional.ofNullable(input.readArray(java.lang.String.class));
                    break;
                case "syntheticDelays":
                    syntheticDelays = java.util.Optional.ofNullable(input.readArray(java.lang.String.class));
                    break;
                case "memoryDumpConfig":
                    memoryDumpConfig = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v129.tracing.model.MemoryDumpConfig.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new TraceConfig(recordMode, traceBufferSizeInKb, enableSampling, enableSystrace, enableArgumentFilter, includedCategories, excludedCategories, syntheticDelays, memoryDumpConfig);
    }
}
