package org.openqa.selenium.devtools.v129.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum GenericIssueErrorType {

    FORMLABELFORNAMEERROR("FormLabelForNameError"),
    FORMDUPLICATEIDFORINPUTERROR("FormDuplicateIdForInputError"),
    FORMINPUTWITHNOLABELERROR("FormInputWithNoLabelError"),
    FORMAUTOCOMPLETEATTRIBUTEEMPTYERROR("FormAutocompleteAttributeEmptyError"),
    FORMEMPTYIDANDNAMEATTRIBUTESFORINPUTERROR("FormEmptyIdAndNameAttributesForInputError"),
    FORMARIALABELLEDBYTONONEXISTINGID("FormAriaLabelledByToNonExistingId"),
    FORMINPUTASSIGNEDAUTOCOMPLETEVALUETOIDORNAMEATTRIBUTEERROR("FormInputAssignedAutocompleteValueToIdOrNameAttributeError"),
    FORMLABELHASNEITHERFORNORNESTEDINPUT("FormLabelHasNeitherForNorNestedInput"),
    FORMLABELFORMATCHESNONEXISTINGIDERROR("FormLabelForMatchesNonExistingIdError"),
    FORMINPUTHASWRONGBUTWELLINTENDEDAUTOCOMPLETEVALUEERROR("FormInputHasWrongButWellIntendedAutocompleteValueError"),
    RESPONSEWASBLOCKEDBYORB("ResponseWasBlockedByORB");

    private String value;

    GenericIssueErrorType(String value) {
        this.value = value;
    }

    public static GenericIssueErrorType fromString(String s) {
        return java.util.Arrays.stream(GenericIssueErrorType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within GenericIssueErrorType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static GenericIssueErrorType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
