package org.openqa.selenium.devtools.v127.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Per-script compilation cache parameters for `Page.produceCompilationCache`
 */
@org.openqa.selenium.Beta()
public class CompilationCacheParams {

    private final java.lang.String url;

    private final java.util.Optional<java.lang.Boolean> eager;

    public CompilationCacheParams(java.lang.String url, java.util.Optional<java.lang.Boolean> eager) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.eager = eager;
    }

    /**
     * The URL of the script to produce a compilation cache entry for.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * A hint to the backend whether eager compilation is recommended.
     * (the actual compilation mode used is upon backend discretion).
     */
    public java.util.Optional<java.lang.Boolean> getEager() {
        return eager;
    }

    private static CompilationCacheParams fromJson(JsonInput input) {
        java.lang.String url = null;
        java.util.Optional<java.lang.Boolean> eager = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "eager":
                    eager = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CompilationCacheParams(url, eager);
    }
}
