package org.openqa.selenium.devtools.v126.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Shared storage was accessed by the associated page.
 * The following parameters are included in all events.
 */
public class SharedStorageAccessed {

    private final org.openqa.selenium.devtools.v126.network.model.TimeSinceEpoch accessTime;

    private final org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessType type;

    private final org.openqa.selenium.devtools.v126.page.model.FrameId mainFrameId;

    private final java.lang.String ownerOrigin;

    private final org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessParams params;

    public SharedStorageAccessed(org.openqa.selenium.devtools.v126.network.model.TimeSinceEpoch accessTime, org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessType type, org.openqa.selenium.devtools.v126.page.model.FrameId mainFrameId, java.lang.String ownerOrigin, org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessParams params) {
        this.accessTime = java.util.Objects.requireNonNull(accessTime, "accessTime is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.mainFrameId = java.util.Objects.requireNonNull(mainFrameId, "mainFrameId is required");
        this.ownerOrigin = java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        this.params = java.util.Objects.requireNonNull(params, "params is required");
    }

    /**
     * Time of the access.
     */
    public org.openqa.selenium.devtools.v126.network.model.TimeSinceEpoch getAccessTime() {
        return accessTime;
    }

    /**
     * Enum value indicating the Shared Storage API method invoked.
     */
    public org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessType getType() {
        return type;
    }

    /**
     * DevTools Frame Token for the primary frame tree's root.
     */
    public org.openqa.selenium.devtools.v126.page.model.FrameId getMainFrameId() {
        return mainFrameId;
    }

    /**
     * Serialized origin for the context that invoked the Shared Storage API.
     */
    public java.lang.String getOwnerOrigin() {
        return ownerOrigin;
    }

    /**
     * The sub-parameters wrapped by `params` are all optional and their
     * presence/absence depends on `type`.
     */
    public org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessParams getParams() {
        return params;
    }

    private static SharedStorageAccessed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v126.network.model.TimeSinceEpoch accessTime = null;
        org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessType type = null;
        org.openqa.selenium.devtools.v126.page.model.FrameId mainFrameId = null;
        java.lang.String ownerOrigin = null;
        org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessParams params = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "accessTime":
                    accessTime = input.read(org.openqa.selenium.devtools.v126.network.model.TimeSinceEpoch.class);
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessType.class);
                    break;
                case "mainFrameId":
                    mainFrameId = input.read(org.openqa.selenium.devtools.v126.page.model.FrameId.class);
                    break;
                case "ownerOrigin":
                    ownerOrigin = input.nextString();
                    break;
                case "params":
                    params = input.read(org.openqa.selenium.devtools.v126.storage.model.SharedStorageAccessParams.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStorageAccessed(accessTime, type, mainFrameId, ownerOrigin, params);
    }
}
