package org.openqa.selenium.devtools.v126.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Default font sizes.
 */
@org.openqa.selenium.Beta()
public class FontSizes {

    private final java.util.Optional<java.lang.Integer> standard;

    private final java.util.Optional<java.lang.Integer> fixed;

    public FontSizes(java.util.Optional<java.lang.Integer> standard, java.util.Optional<java.lang.Integer> fixed) {
        this.standard = standard;
        this.fixed = fixed;
    }

    /**
     * Default standard font size.
     */
    public java.util.Optional<java.lang.Integer> getStandard() {
        return standard;
    }

    /**
     * Default fixed font size.
     */
    public java.util.Optional<java.lang.Integer> getFixed() {
        return fixed;
    }

    private static FontSizes fromJson(JsonInput input) {
        java.util.Optional<java.lang.Integer> standard = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> fixed = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "standard":
                    standard = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "fixed":
                    fixed = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FontSizes(standard, fixed);
    }
}
