package org.openqa.selenium.devtools.v125.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum StorageBucketsDurability {

    RELAXED("relaxed"), STRICT("strict");

    private String value;

    StorageBucketsDurability(String value) {
        this.value = value;
    }

    public static StorageBucketsDurability fromString(String s) {
        return java.util.Arrays.stream(StorageBucketsDurability.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within StorageBucketsDurability "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static StorageBucketsDurability fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
