package org.openqa.selenium.devtools.v125.pwa;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows interacting with the browser to control PWAs.
 */
@Beta()
public class PWA {

    public static class GetOsAppStateResponse {

        private final java.lang.Integer badgeCount;

        private final java.util.List<org.openqa.selenium.devtools.v125.pwa.model.FileHandler> fileHandlers;

        public GetOsAppStateResponse(java.lang.Integer badgeCount, java.util.List<org.openqa.selenium.devtools.v125.pwa.model.FileHandler> fileHandlers) {
            this.badgeCount = java.util.Objects.requireNonNull(badgeCount, "badgeCount is required");
            this.fileHandlers = java.util.Objects.requireNonNull(fileHandlers, "fileHandlers is required");
        }

        public java.lang.Integer getBadgeCount() {
            return badgeCount;
        }

        public java.util.List<org.openqa.selenium.devtools.v125.pwa.model.FileHandler> getFileHandlers() {
            return fileHandlers;
        }

        private static GetOsAppStateResponse fromJson(JsonInput input) {
            java.lang.Integer badgeCount = 0;
            java.util.List<org.openqa.selenium.devtools.v125.pwa.model.FileHandler> fileHandlers = null;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "badgeCount":
                        badgeCount = input.nextNumber().intValue();
                        break;
                    case "fileHandlers":
                        fileHandlers = input.readArray(org.openqa.selenium.devtools.v125.pwa.model.FileHandler.class);
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetOsAppStateResponse(badgeCount, fileHandlers);
        }
    }

    /**
     * Returns the following OS state for the given manifest id.
     */
    public static Command<org.openqa.selenium.devtools.v125.pwa.PWA.GetOsAppStateResponse> getOsAppState(java.lang.String manifestId) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        return new Command<>("PWA.getOsAppState", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v125.pwa.PWA.GetOsAppStateResponse.class));
    }
}
