package org.openqa.selenium.devtools.v124.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Types of reasons why a cookie should have been blocked by 3PCD but is exempted for the request.
 */
@org.openqa.selenium.Beta()
public enum CookieExemptionReason {

    NONE("None"),
    USERSETTING("UserSetting"),
    TPCDMETADATA("TPCDMetadata"),
    TPCDDEPRECATIONTRIAL("TPCDDeprecationTrial"),
    TPCDHEURISTICS("TPCDHeuristics"),
    ENTERPRISEPOLICY("EnterprisePolicy"),
    STORAGEACCESS("StorageAccess"),
    TOPLEVELSTORAGEACCESS("TopLevelStorageAccess"),
    CORSOPTIN("CorsOptIn");

    private String value;

    CookieExemptionReason(String value) {
        this.value = value;
    }

    public static CookieExemptionReason fromString(String s) {
        return java.util.Arrays.stream(CookieExemptionReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CookieExemptionReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CookieExemptionReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
