/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v124.webaudio.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v124.webaudio.model.AutomationRate;
import org.openqa.selenium.devtools.v124.webaudio.model.GraphObjectId;
import org.openqa.selenium.devtools.v124.webaudio.model.ParamType;
import org.openqa.selenium.json.JsonInput;

public class AudioParam {
    private final GraphObjectId paramId;
    private final GraphObjectId nodeId;
    private final GraphObjectId contextId;
    private final ParamType paramType;
    private final AutomationRate rate;
    private final Number defaultValue;
    private final Number minValue;
    private final Number maxValue;

    public AudioParam(GraphObjectId paramId, GraphObjectId nodeId, GraphObjectId contextId, ParamType paramType, AutomationRate rate, Number defaultValue, Number minValue, Number maxValue) {
        this.paramId = Objects.requireNonNull(paramId, "paramId is required");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.contextId = Objects.requireNonNull(contextId, "contextId is required");
        this.paramType = Objects.requireNonNull(paramType, "paramType is required");
        this.rate = Objects.requireNonNull(rate, "rate is required");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is required");
        this.minValue = Objects.requireNonNull(minValue, "minValue is required");
        this.maxValue = Objects.requireNonNull(maxValue, "maxValue is required");
    }

    public GraphObjectId getParamId() {
        return this.paramId;
    }

    public GraphObjectId getNodeId() {
        return this.nodeId;
    }

    public GraphObjectId getContextId() {
        return this.contextId;
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    public AutomationRate getRate() {
        return this.rate;
    }

    public Number getDefaultValue() {
        return this.defaultValue;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    private static AudioParam fromJson(JsonInput input) {
        GraphObjectId paramId = null;
        GraphObjectId nodeId = null;
        GraphObjectId contextId = null;
        ParamType paramType = null;
        AutomationRate rate = null;
        Number defaultValue = 0;
        Number minValue = 0;
        Number maxValue = 0;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "paramId": {
                    paramId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block20;
                }
                case "nodeId": {
                    nodeId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block20;
                }
                case "contextId": {
                    contextId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block20;
                }
                case "paramType": {
                    paramType = (ParamType)input.read(ParamType.class);
                    continue block20;
                }
                case "rate": {
                    rate = (AutomationRate)((Object)input.read(AutomationRate.class));
                    continue block20;
                }
                case "defaultValue": {
                    defaultValue = input.nextNumber();
                    continue block20;
                }
                case "minValue": {
                    minValue = input.nextNumber();
                    continue block20;
                }
                case "maxValue": {
                    maxValue = input.nextNumber();
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AudioParam(paramId, nodeId, contextId, paramType, rate, defaultValue, minValue, maxValue);
    }
}

