/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v124.page.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v124.page.model.ClientNavigationDisposition;
import org.openqa.selenium.devtools.v124.page.model.ClientNavigationReason;
import org.openqa.selenium.devtools.v124.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class FrameRequestedNavigation {
    private final FrameId frameId;
    private final ClientNavigationReason reason;
    private final String url;
    private final ClientNavigationDisposition disposition;

    public FrameRequestedNavigation(FrameId frameId, ClientNavigationReason reason, String url, ClientNavigationDisposition disposition) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.reason = Objects.requireNonNull(reason, "reason is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.disposition = Objects.requireNonNull(disposition, "disposition is required");
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public ClientNavigationReason getReason() {
        return this.reason;
    }

    public String getUrl() {
        return this.url;
    }

    public ClientNavigationDisposition getDisposition() {
        return this.disposition;
    }

    private static FrameRequestedNavigation fromJson(JsonInput input) {
        FrameId frameId = null;
        ClientNavigationReason reason = null;
        String url = null;
        ClientNavigationDisposition disposition = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block12;
                }
                case "reason": {
                    reason = (ClientNavigationReason)((Object)input.read(ClientNavigationReason.class));
                    continue block12;
                }
                case "url": {
                    url = input.nextString();
                    continue block12;
                }
                case "disposition": {
                    disposition = (ClientNavigationDisposition)((Object)input.read(ClientNavigationDisposition.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameRequestedNavigation(frameId, reason, url, disposition);
    }
}

