package org.openqa.selenium.devtools.v121.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class StorageBucketInfo {

    private final org.openqa.selenium.devtools.v121.storage.model.StorageBucket bucket;

    private final java.lang.String id;

    private final org.openqa.selenium.devtools.v121.network.model.TimeSinceEpoch expiration;

    private final java.lang.Number quota;

    private final java.lang.Boolean persistent;

    private final org.openqa.selenium.devtools.v121.storage.model.StorageBucketsDurability durability;

    public StorageBucketInfo(org.openqa.selenium.devtools.v121.storage.model.StorageBucket bucket, java.lang.String id, org.openqa.selenium.devtools.v121.network.model.TimeSinceEpoch expiration, java.lang.Number quota, java.lang.Boolean persistent, org.openqa.selenium.devtools.v121.storage.model.StorageBucketsDurability durability) {
        this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.expiration = java.util.Objects.requireNonNull(expiration, "expiration is required");
        this.quota = java.util.Objects.requireNonNull(quota, "quota is required");
        this.persistent = java.util.Objects.requireNonNull(persistent, "persistent is required");
        this.durability = java.util.Objects.requireNonNull(durability, "durability is required");
    }

    public org.openqa.selenium.devtools.v121.storage.model.StorageBucket getBucket() {
        return bucket;
    }

    public java.lang.String getId() {
        return id;
    }

    public org.openqa.selenium.devtools.v121.network.model.TimeSinceEpoch getExpiration() {
        return expiration;
    }

    /**
     * Storage quota (bytes).
     */
    public java.lang.Number getQuota() {
        return quota;
    }

    public java.lang.Boolean getPersistent() {
        return persistent;
    }

    public org.openqa.selenium.devtools.v121.storage.model.StorageBucketsDurability getDurability() {
        return durability;
    }

    private static StorageBucketInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v121.storage.model.StorageBucket bucket = null;
        java.lang.String id = null;
        org.openqa.selenium.devtools.v121.network.model.TimeSinceEpoch expiration = null;
        java.lang.Number quota = 0;
        java.lang.Boolean persistent = false;
        org.openqa.selenium.devtools.v121.storage.model.StorageBucketsDurability durability = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "bucket":
                    bucket = input.read(org.openqa.selenium.devtools.v121.storage.model.StorageBucket.class);
                    break;
                case "id":
                    id = input.nextString();
                    break;
                case "expiration":
                    expiration = input.read(org.openqa.selenium.devtools.v121.network.model.TimeSinceEpoch.class);
                    break;
                case "quota":
                    quota = input.nextNumber();
                    break;
                case "persistent":
                    persistent = input.nextBoolean();
                    break;
                case "durability":
                    durability = input.read(org.openqa.selenium.devtools.v121.storage.model.StorageBucketsDurability.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new StorageBucketInfo(bucket, id, expiration, quota, persistent, durability);
    }
}
