package org.openqa.selenium.devtools.v120.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum ContrastAlgorithm {

    AA("aa"), AAA("aaa"), APCA("apca");

    private String value;

    ContrastAlgorithm(String value) {
        this.value = value;
    }

    public static ContrastAlgorithm fromString(String s) {
        return java.util.Arrays.stream(ContrastAlgorithm.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ContrastAlgorithm "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ContrastAlgorithm fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
