package org.openqa.selenium.devtools.v120.animation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Keyframes Rule
 */
public class KeyframesRule {

    private final java.util.Optional<java.lang.String> name;

    private final java.util.List<org.openqa.selenium.devtools.v120.animation.model.KeyframeStyle> keyframes;

    public KeyframesRule(java.util.Optional<java.lang.String> name, java.util.List<org.openqa.selenium.devtools.v120.animation.model.KeyframeStyle> keyframes) {
        this.name = name;
        this.keyframes = java.util.Objects.requireNonNull(keyframes, "keyframes is required");
    }

    /**
     * CSS keyframed animation's name.
     */
    public java.util.Optional<java.lang.String> getName() {
        return name;
    }

    /**
     * List of animation keyframes.
     */
    public java.util.List<org.openqa.selenium.devtools.v120.animation.model.KeyframeStyle> getKeyframes() {
        return keyframes;
    }

    private static KeyframesRule fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> name = java.util.Optional.empty();
        java.util.List<org.openqa.selenium.devtools.v120.animation.model.KeyframeStyle> keyframes = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "keyframes":
                    keyframes = input.readArray(org.openqa.selenium.devtools.v120.animation.model.KeyframeStyle.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new KeyframesRule(name, keyframes);
    }
}
