/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v119.cast;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v119.cast.model.Sink;

@Beta
public class Cast {
    public static Command<Void> enable(Optional<String> presentationUrl) {
        LinkedHashMap params = new LinkedHashMap();
        presentationUrl.ifPresent(p -> params.put("presentationUrl", p));
        return new Command("Cast.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Cast.disable", Map.copyOf(params));
    }

    public static Command<Void> setSinkToUse(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("sinkName", sinkName);
        return new Command("Cast.setSinkToUse", Map.copyOf(params));
    }

    public static Command<Void> startDesktopMirroring(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("sinkName", sinkName);
        return new Command("Cast.startDesktopMirroring", Map.copyOf(params));
    }

    public static Command<Void> startTabMirroring(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("sinkName", sinkName);
        return new Command("Cast.startTabMirroring", Map.copyOf(params));
    }

    public static Command<Void> stopCasting(String sinkName) {
        Objects.requireNonNull(sinkName, "sinkName is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("sinkName", sinkName);
        return new Command("Cast.stopCasting", Map.copyOf(params));
    }

    public static Event<List<Sink>> sinksUpdated() {
        return new Event("Cast.sinksUpdated", ConverterFunctions.map((String)"sinks", input -> input.readArray(Sink.class)));
    }

    public static Event<String> issueUpdated() {
        return new Event("Cast.issueUpdated", ConverterFunctions.map((String)"issueMessage", String.class));
    }
}

