package org.openqa.selenium.devtools.v117.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A cookie which was not stored from a response with the corresponding reason.
 */
@org.openqa.selenium.Beta()
public class BlockedSetCookieWithReason {

    private final java.util.List<org.openqa.selenium.devtools.v117.network.model.SetCookieBlockedReason> blockedReasons;

    private final java.lang.String cookieLine;

    private final java.util.Optional<org.openqa.selenium.devtools.v117.network.model.Cookie> cookie;

    public BlockedSetCookieWithReason(java.util.List<org.openqa.selenium.devtools.v117.network.model.SetCookieBlockedReason> blockedReasons, java.lang.String cookieLine, java.util.Optional<org.openqa.selenium.devtools.v117.network.model.Cookie> cookie) {
        this.blockedReasons = java.util.Objects.requireNonNull(blockedReasons, "blockedReasons is required");
        this.cookieLine = java.util.Objects.requireNonNull(cookieLine, "cookieLine is required");
        this.cookie = cookie;
    }

    /**
     * The reason(s) this cookie was blocked.
     */
    public java.util.List<org.openqa.selenium.devtools.v117.network.model.SetCookieBlockedReason> getBlockedReasons() {
        return blockedReasons;
    }

    /**
     * The string representing this individual cookie as it would appear in the header.
     * This is not the entire "cookie" or "set-cookie" header which could have multiple cookies.
     */
    public java.lang.String getCookieLine() {
        return cookieLine;
    }

    /**
     * The cookie object which represents the cookie which was not stored. It is optional because
     * sometimes complete cookie information is not available, such as in the case of parsing
     * errors.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v117.network.model.Cookie> getCookie() {
        return cookie;
    }

    private static BlockedSetCookieWithReason fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v117.network.model.SetCookieBlockedReason> blockedReasons = null;
        java.lang.String cookieLine = null;
        java.util.Optional<org.openqa.selenium.devtools.v117.network.model.Cookie> cookie = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "blockedReasons":
                    blockedReasons = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v117.network.model.SetCookieBlockedReason>>() {
                    }.getType());
                    break;
                case "cookieLine":
                    cookieLine = input.nextString();
                    break;
                case "cookie":
                    cookie = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v117.network.model.Cookie.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BlockedSetCookieWithReason(blockedReasons, cookieLine, cookie);
    }
}
