/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v116.preload.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v116.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v116.network.model.LoaderId;
import org.openqa.selenium.devtools.v116.network.model.RequestId;
import org.openqa.selenium.devtools.v116.preload.model.RuleSetErrorType;
import org.openqa.selenium.devtools.v116.preload.model.RuleSetId;
import org.openqa.selenium.json.JsonInput;

public class RuleSet {
    private final RuleSetId id;
    private final LoaderId loaderId;
    private final String sourceText;
    private final Optional<BackendNodeId> backendNodeId;
    private final Optional<String> url;
    private final Optional<RequestId> requestId;
    private final Optional<RuleSetErrorType> errorType;
    private final Optional<String> errorMessage;

    public RuleSet(RuleSetId id, LoaderId loaderId, String sourceText, Optional<BackendNodeId> backendNodeId, Optional<String> url, Optional<RequestId> requestId, Optional<RuleSetErrorType> errorType, Optional<String> errorMessage) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.sourceText = Objects.requireNonNull(sourceText, "sourceText is required");
        this.backendNodeId = backendNodeId;
        this.url = url;
        this.requestId = requestId;
        this.errorType = errorType;
        this.errorMessage = errorMessage;
    }

    public RuleSetId getId() {
        return this.id;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public Optional<BackendNodeId> getBackendNodeId() {
        return this.backendNodeId;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<RequestId> getRequestId() {
        return this.requestId;
    }

    public Optional<RuleSetErrorType> getErrorType() {
        return this.errorType;
    }

    @Deprecated
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    private static RuleSet fromJson(JsonInput input) {
        RuleSetId id = null;
        LoaderId loaderId = null;
        String sourceText = null;
        Optional<BackendNodeId> backendNodeId = Optional.empty();
        Optional<String> url = Optional.empty();
        Optional<RequestId> requestId = Optional.empty();
        Optional<RuleSetErrorType> errorType = Optional.empty();
        Optional<String> errorMessage = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (RuleSetId)input.read(RuleSetId.class);
                    continue block20;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read(LoaderId.class);
                    continue block20;
                }
                case "sourceText": {
                    sourceText = input.nextString();
                    continue block20;
                }
                case "backendNodeId": {
                    backendNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block20;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "requestId": {
                    requestId = Optional.ofNullable((RequestId)input.read(RequestId.class));
                    continue block20;
                }
                case "errorType": {
                    errorType = Optional.ofNullable((RuleSetErrorType)((Object)input.read(RuleSetErrorType.class)));
                    continue block20;
                }
                case "errorMessage": {
                    errorMessage = Optional.ofNullable(input.nextString());
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RuleSet(id, loaderId, sourceText, backendNodeId, url, requestId, errorType, errorMessage);
    }
}

