package org.openqa.selenium.devtools.v115.deviceaccess.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A device request opened a user prompt to select a device. Respond with the
 * selectPrompt or cancelPrompt command.
 */
public class DeviceRequestPrompted {

    private final org.openqa.selenium.devtools.v115.deviceaccess.model.RequestId id;

    private final java.util.List<org.openqa.selenium.devtools.v115.deviceaccess.model.PromptDevice> devices;

    public DeviceRequestPrompted(org.openqa.selenium.devtools.v115.deviceaccess.model.RequestId id, java.util.List<org.openqa.selenium.devtools.v115.deviceaccess.model.PromptDevice> devices) {
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.devices = java.util.Objects.requireNonNull(devices, "devices is required");
    }

    public org.openqa.selenium.devtools.v115.deviceaccess.model.RequestId getId() {
        return id;
    }

    public java.util.List<org.openqa.selenium.devtools.v115.deviceaccess.model.PromptDevice> getDevices() {
        return devices;
    }

    private static DeviceRequestPrompted fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v115.deviceaccess.model.RequestId id = null;
        java.util.List<org.openqa.selenium.devtools.v115.deviceaccess.model.PromptDevice> devices = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = input.read(org.openqa.selenium.devtools.v115.deviceaccess.model.RequestId.class);
                    break;
                case "devices":
                    devices = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v115.deviceaccess.model.PromptDevice>>() {
                    }.getType());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DeviceRequestPrompted(id, devices);
    }
}
