/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.fedcm.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v114.fedcm.model.Account;
import org.openqa.selenium.json.JsonInput;

public class DialogShown {
    private final String dialogId;
    private final List<Account> accounts;
    private final String title;
    private final Optional<String> subtitle;

    public DialogShown(String dialogId, List<Account> accounts, String title, Optional<String> subtitle) {
        this.dialogId = Objects.requireNonNull(dialogId, "dialogId is required");
        this.accounts = Objects.requireNonNull(accounts, "accounts is required");
        this.title = Objects.requireNonNull(title, "title is required");
        this.subtitle = subtitle;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public String getTitle() {
        return this.title;
    }

    public Optional<String> getSubtitle() {
        return this.subtitle;
    }

    private static DialogShown fromJson(JsonInput input) {
        String dialogId = null;
        List accounts = null;
        String title = null;
        Optional<String> subtitle = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "dialogId": {
                    dialogId = input.nextString();
                    continue block12;
                }
                case "accounts": {
                    accounts = (List)input.read(new TypeToken<List<Account>>(){}.getType());
                    continue block12;
                }
                case "title": {
                    title = input.nextString();
                    continue block12;
                }
                case "subtitle": {
                    subtitle = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DialogShown(dialogId, accounts, title, subtitle);
    }
}

