package org.openqa.selenium.devtools.v114.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a prerender attempt is updated.
 */
public class PrerenderStatusUpdated {

    private final org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey key;

    private final org.openqa.selenium.devtools.v114.page.model.FrameId initiatingFrameId;

    private final java.lang.String prerenderingUrl;

    private final org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus status;

    public PrerenderStatusUpdated(org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey key, org.openqa.selenium.devtools.v114.page.model.FrameId initiatingFrameId, java.lang.String prerenderingUrl, org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus status) {
        this.key = java.util.Objects.requireNonNull(key, "key is required");
        this.initiatingFrameId = java.util.Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = java.util.Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.status = java.util.Objects.requireNonNull(status, "status is required");
    }

    public org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey getKey() {
        return key;
    }

    /**
     * The frame id of the frame initiating prerender.
     */
    public org.openqa.selenium.devtools.v114.page.model.FrameId getInitiatingFrameId() {
        return initiatingFrameId;
    }

    public java.lang.String getPrerenderingUrl() {
        return prerenderingUrl;
    }

    public org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus getStatus() {
        return status;
    }

    private static PrerenderStatusUpdated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey key = null;
        org.openqa.selenium.devtools.v114.page.model.FrameId initiatingFrameId = null;
        java.lang.String prerenderingUrl = null;
        org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus status = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "key":
                    key = input.read(org.openqa.selenium.devtools.v114.preload.model.PreloadingAttemptKey.class);
                    break;
                case "initiatingFrameId":
                    initiatingFrameId = input.read(org.openqa.selenium.devtools.v114.page.model.FrameId.class);
                    break;
                case "prerenderingUrl":
                    prerenderingUrl = input.nextString();
                    break;
                case "status":
                    status = input.read(org.openqa.selenium.devtools.v114.preload.model.PreloadingStatus.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrerenderStatusUpdated(key, initiatingFrameId, prerenderingUrl, status);
    }
}
