package org.openqa.selenium.devtools.v114.fedcm.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class DialogShown {

    private final java.lang.String dialogId;

    private final java.util.List<org.openqa.selenium.devtools.v114.fedcm.model.Account> accounts;

    private final java.lang.String title;

    private final java.util.Optional<java.lang.String> subtitle;

    public DialogShown(java.lang.String dialogId, java.util.List<org.openqa.selenium.devtools.v114.fedcm.model.Account> accounts, java.lang.String title, java.util.Optional<java.lang.String> subtitle) {
        this.dialogId = java.util.Objects.requireNonNull(dialogId, "dialogId is required");
        this.accounts = java.util.Objects.requireNonNull(accounts, "accounts is required");
        this.title = java.util.Objects.requireNonNull(title, "title is required");
        this.subtitle = subtitle;
    }

    public java.lang.String getDialogId() {
        return dialogId;
    }

    public java.util.List<org.openqa.selenium.devtools.v114.fedcm.model.Account> getAccounts() {
        return accounts;
    }

    /**
     * These exist primarily so that the caller can verify the
     * RP context was used appropriately.
     */
    public java.lang.String getTitle() {
        return title;
    }

    public java.util.Optional<java.lang.String> getSubtitle() {
        return subtitle;
    }

    private static DialogShown fromJson(JsonInput input) {
        java.lang.String dialogId = null;
        java.util.List<org.openqa.selenium.devtools.v114.fedcm.model.Account> accounts = null;
        java.lang.String title = null;
        java.util.Optional<java.lang.String> subtitle = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "dialogId":
                    dialogId = input.nextString();
                    break;
                case "accounts":
                    accounts = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v114.fedcm.model.Account>>() {
                    }.getType());
                    break;
                case "title":
                    title = input.nextString();
                    break;
                case "subtitle":
                    subtitle = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DialogShown(dialogId, accounts, title, subtitle);
    }
}
