/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.overlay.model;

import java.util.Optional;
import org.openqa.selenium.devtools.v114.dom.model.RGBA;
import org.openqa.selenium.json.JsonInput;

public class IsolationModeHighlightConfig {
    private final Optional<RGBA> resizerColor;
    private final Optional<RGBA> resizerHandleColor;
    private final Optional<RGBA> maskColor;

    public IsolationModeHighlightConfig(Optional<RGBA> resizerColor, Optional<RGBA> resizerHandleColor, Optional<RGBA> maskColor) {
        this.resizerColor = resizerColor;
        this.resizerHandleColor = resizerHandleColor;
        this.maskColor = maskColor;
    }

    public Optional<RGBA> getResizerColor() {
        return this.resizerColor;
    }

    public Optional<RGBA> getResizerHandleColor() {
        return this.resizerHandleColor;
    }

    public Optional<RGBA> getMaskColor() {
        return this.maskColor;
    }

    private static IsolationModeHighlightConfig fromJson(JsonInput input) {
        Optional<RGBA> resizerColor = Optional.empty();
        Optional<RGBA> resizerHandleColor = Optional.empty();
        Optional<RGBA> maskColor = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "resizerColor": {
                    resizerColor = Optional.ofNullable((RGBA)input.read(RGBA.class));
                    continue block10;
                }
                case "resizerHandleColor": {
                    resizerHandleColor = Optional.ofNullable((RGBA)input.read(RGBA.class));
                    continue block10;
                }
                case "maskColor": {
                    maskColor = Optional.ofNullable((RGBA)input.read(RGBA.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new IsolationModeHighlightConfig(resizerColor, resizerHandleColor, maskColor);
    }
}

