package org.openqa.selenium.devtools.v113.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class DisplayFeature {

    public enum Orientation {

        VERTICAL("vertical"), HORIZONTAL("horizontal");

        private String value;

        Orientation(String value) {
            this.value = value;
        }

        public static Orientation fromString(String s) {
            return java.util.Arrays.stream(Orientation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Orientation "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Orientation fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Orientation orientation;

    private final java.lang.Integer offset;

    private final java.lang.Integer maskLength;

    public DisplayFeature(Orientation orientation, java.lang.Integer offset, java.lang.Integer maskLength) {
        this.orientation = java.util.Objects.requireNonNull(orientation, "orientation is required");
        this.offset = java.util.Objects.requireNonNull(offset, "offset is required");
        this.maskLength = java.util.Objects.requireNonNull(maskLength, "maskLength is required");
    }

    /**
     * Orientation of a display feature in relation to screen
     */
    public Orientation getOrientation() {
        return orientation;
    }

    /**
     * The offset from the screen origin in either the x (for vertical
     * orientation) or y (for horizontal orientation) direction.
     */
    public java.lang.Integer getOffset() {
        return offset;
    }

    /**
     * A display feature may mask content such that it is not physically
     * displayed - this length along with the offset describes this area.
     * A display feature that only splits content will have a 0 mask_length.
     */
    public java.lang.Integer getMaskLength() {
        return maskLength;
    }

    private static DisplayFeature fromJson(JsonInput input) {
        Orientation orientation = null;
        java.lang.Integer offset = 0;
        java.lang.Integer maskLength = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "orientation":
                    orientation = Orientation.fromString(input.nextString());
                    break;
                case "offset":
                    offset = input.nextNumber().intValue();
                    break;
                case "maskLength":
                    maskLength = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DisplayFeature(orientation, offset, maskLength);
    }
}
