/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v113.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v113.network.model.Cookie;
import org.openqa.selenium.devtools.v113.network.model.CookieParam;
import org.openqa.selenium.devtools.v113.page.model.FrameId;
import org.openqa.selenium.devtools.v113.storage.model.CacheStorageContentUpdated;
import org.openqa.selenium.devtools.v113.storage.model.CacheStorageListUpdated;
import org.openqa.selenium.devtools.v113.storage.model.IndexedDBContentUpdated;
import org.openqa.selenium.devtools.v113.storage.model.IndexedDBListUpdated;
import org.openqa.selenium.devtools.v113.storage.model.InterestGroupAccessed;
import org.openqa.selenium.devtools.v113.storage.model.InterestGroupDetails;
import org.openqa.selenium.devtools.v113.storage.model.SerializedStorageKey;
import org.openqa.selenium.devtools.v113.storage.model.SharedStorageAccessed;
import org.openqa.selenium.devtools.v113.storage.model.SharedStorageEntry;
import org.openqa.selenium.devtools.v113.storage.model.SharedStorageMetadata;
import org.openqa.selenium.devtools.v113.storage.model.StorageBucketInfo;
import org.openqa.selenium.devtools.v113.storage.model.TrustTokens;
import org.openqa.selenium.devtools.v113.storage.model.UsageForType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Storage {
    public static Command<SerializedStorageKey> getStorageKeyForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command("Storage.getStorageKeyForFrame", (Map)params.build(), ConverterFunctions.map((String)"storageKey", SerializedStorageKey.class));
    }

    public static Command<Void> clearDataForOrigin(String origin, String storageTypes) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        params.put((Object)"storageTypes", (Object)storageTypes);
        return new Command("Storage.clearDataForOrigin", (Map)params.build());
    }

    public static Command<Void> clearDataForStorageKey(String storageKey, String storageTypes) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageKey", (Object)storageKey);
        params.put((Object)"storageTypes", (Object)storageTypes);
        return new Command("Storage.clearDataForStorageKey", (Map)params.build());
    }

    public static Command<List<Cookie>> getCookies(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Storage.getCookies", (Map)params.build(), ConverterFunctions.map((String)"cookies", (Type)new TypeToken<List<Cookie>>(){}.getType()));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(cookies, "cookies is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"cookies", cookies);
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Storage.setCookies", (Map)params.build());
    }

    public static Command<Void> clearCookies(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put((Object)"browserContextId", p));
        return new Command("Storage.clearCookies", (Map)params.build());
    }

    public static Command<GetUsageAndQuotaResponse> getUsageAndQuota(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.getUsageAndQuota", (Map)params.build(), input -> (GetUsageAndQuotaResponse)input.read(GetUsageAndQuotaResponse.class));
    }

    @Beta
    public static Command<Void> overrideQuotaForOrigin(String origin, Optional<Number> quotaSize) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        quotaSize.ifPresent(p -> params.put((Object)"quotaSize", p));
        return new Command("Storage.overrideQuotaForOrigin", (Map)params.build());
    }

    public static Command<Void> trackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.trackCacheStorageForOrigin", (Map)params.build());
    }

    public static Command<Void> trackCacheStorageForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageKey", (Object)storageKey);
        return new Command("Storage.trackCacheStorageForStorageKey", (Map)params.build());
    }

    public static Command<Void> trackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.trackIndexedDBForOrigin", (Map)params.build());
    }

    public static Command<Void> trackIndexedDBForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageKey", (Object)storageKey);
        return new Command("Storage.trackIndexedDBForStorageKey", (Map)params.build());
    }

    public static Command<Void> untrackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.untrackCacheStorageForOrigin", (Map)params.build());
    }

    public static Command<Void> untrackCacheStorageForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageKey", (Object)storageKey);
        return new Command("Storage.untrackCacheStorageForStorageKey", (Map)params.build());
    }

    public static Command<Void> untrackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"origin", (Object)origin);
        return new Command("Storage.untrackIndexedDBForOrigin", (Map)params.build());
    }

    public static Command<Void> untrackIndexedDBForStorageKey(String storageKey) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageKey", (Object)storageKey);
        return new Command("Storage.untrackIndexedDBForStorageKey", (Map)params.build());
    }

    @Beta
    public static Command<List<TrustTokens>> getTrustTokens() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Storage.getTrustTokens", (Map)params.build(), ConverterFunctions.map((String)"tokens", (Type)new TypeToken<List<TrustTokens>>(){}.getType()));
    }

    @Beta
    public static Command<Boolean> clearTrustTokens(String issuerOrigin) {
        Objects.requireNonNull(issuerOrigin, "issuerOrigin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"issuerOrigin", (Object)issuerOrigin);
        return new Command("Storage.clearTrustTokens", (Map)params.build(), ConverterFunctions.map((String)"didDeleteTokens", Boolean.class));
    }

    @Beta
    public static Command<InterestGroupDetails> getInterestGroupDetails(String ownerOrigin, String name) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"ownerOrigin", (Object)ownerOrigin);
        params.put((Object)"name", (Object)name);
        return new Command("Storage.getInterestGroupDetails", (Map)params.build(), ConverterFunctions.map((String)"details", InterestGroupDetails.class));
    }

    @Beta
    public static Command<Void> setInterestGroupTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enable", (Object)enable);
        return new Command("Storage.setInterestGroupTracking", (Map)params.build());
    }

    @Beta
    public static Command<SharedStorageMetadata> getSharedStorageMetadata(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"ownerOrigin", (Object)ownerOrigin);
        return new Command("Storage.getSharedStorageMetadata", (Map)params.build(), ConverterFunctions.map((String)"metadata", SharedStorageMetadata.class));
    }

    @Beta
    public static Command<List<SharedStorageEntry>> getSharedStorageEntries(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"ownerOrigin", (Object)ownerOrigin);
        return new Command("Storage.getSharedStorageEntries", (Map)params.build(), ConverterFunctions.map((String)"entries", (Type)new TypeToken<List<SharedStorageEntry>>(){}.getType()));
    }

    @Beta
    public static Command<Void> setSharedStorageEntry(String ownerOrigin, String key, String value, Optional<Boolean> ignoreIfPresent) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"ownerOrigin", (Object)ownerOrigin);
        params.put((Object)"key", (Object)key);
        params.put((Object)"value", (Object)value);
        ignoreIfPresent.ifPresent(p -> params.put((Object)"ignoreIfPresent", p));
        return new Command("Storage.setSharedStorageEntry", (Map)params.build());
    }

    @Beta
    public static Command<Void> deleteSharedStorageEntry(String ownerOrigin, String key) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        Objects.requireNonNull(key, "key is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"ownerOrigin", (Object)ownerOrigin);
        params.put((Object)"key", (Object)key);
        return new Command("Storage.deleteSharedStorageEntry", (Map)params.build());
    }

    @Beta
    public static Command<Void> clearSharedStorageEntries(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"ownerOrigin", (Object)ownerOrigin);
        return new Command("Storage.clearSharedStorageEntries", (Map)params.build());
    }

    @Beta
    public static Command<Void> resetSharedStorageBudget(String ownerOrigin) {
        Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"ownerOrigin", (Object)ownerOrigin);
        return new Command("Storage.resetSharedStorageBudget", (Map)params.build());
    }

    @Beta
    public static Command<Void> setSharedStorageTracking(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enable", (Object)enable);
        return new Command("Storage.setSharedStorageTracking", (Map)params.build());
    }

    @Beta
    public static Command<Void> setStorageBucketTracking(String storageKey, Boolean enable) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageKey", (Object)storageKey);
        params.put((Object)"enable", (Object)enable);
        return new Command("Storage.setStorageBucketTracking", (Map)params.build());
    }

    @Beta
    public static Command<Void> deleteStorageBucket(String storageKey, String bucketName) {
        Objects.requireNonNull(storageKey, "storageKey is required");
        Objects.requireNonNull(bucketName, "bucketName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"storageKey", (Object)storageKey);
        params.put((Object)"bucketName", (Object)bucketName);
        return new Command("Storage.deleteStorageBucket", (Map)params.build());
    }

    public static Event<CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event("Storage.cacheStorageContentUpdated", input -> (CacheStorageContentUpdated)input.read(CacheStorageContentUpdated.class));
    }

    public static Event<CacheStorageListUpdated> cacheStorageListUpdated() {
        return new Event("Storage.cacheStorageListUpdated", input -> (CacheStorageListUpdated)input.read(CacheStorageListUpdated.class));
    }

    public static Event<IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event("Storage.indexedDBContentUpdated", input -> (IndexedDBContentUpdated)input.read(IndexedDBContentUpdated.class));
    }

    public static Event<IndexedDBListUpdated> indexedDBListUpdated() {
        return new Event("Storage.indexedDBListUpdated", input -> (IndexedDBListUpdated)input.read(IndexedDBListUpdated.class));
    }

    public static Event<InterestGroupAccessed> interestGroupAccessed() {
        return new Event("Storage.interestGroupAccessed", input -> (InterestGroupAccessed)input.read(InterestGroupAccessed.class));
    }

    public static Event<SharedStorageAccessed> sharedStorageAccessed() {
        return new Event("Storage.sharedStorageAccessed", input -> (SharedStorageAccessed)input.read(SharedStorageAccessed.class));
    }

    public static Event<StorageBucketInfo> storageBucketCreatedOrUpdated() {
        return new Event("Storage.storageBucketCreatedOrUpdated", ConverterFunctions.map((String)"bucket", StorageBucketInfo.class));
    }

    public static Event<String> storageBucketDeleted() {
        return new Event("Storage.storageBucketDeleted", ConverterFunctions.map((String)"bucketId", String.class));
    }

    public static class GetUsageAndQuotaResponse {
        private final Number usage;
        private final Number quota;
        private final Boolean overrideActive;
        private final List<UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(Number usage, Number quota, Boolean overrideActive, List<UsageForType> usageBreakdown) {
            this.usage = Objects.requireNonNull(usage, "usage is required");
            this.quota = Objects.requireNonNull(quota, "quota is required");
            this.overrideActive = Objects.requireNonNull(overrideActive, "overrideActive is required");
            this.usageBreakdown = Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        public Number getUsage() {
            return this.usage;
        }

        public Number getQuota() {
            return this.quota;
        }

        public Boolean getOverrideActive() {
            return this.overrideActive;
        }

        public List<UsageForType> getUsageBreakdown() {
            return this.usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            Number usage = 0;
            Number quota = 0;
            Boolean overrideActive = false;
            List usageBreakdown = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usage": {
                        usage = input.nextNumber();
                        continue block12;
                    }
                    case "quota": {
                        quota = input.nextNumber();
                        continue block12;
                    }
                    case "overrideActive": {
                        overrideActive = input.nextBoolean();
                        continue block12;
                    }
                    case "usageBreakdown": {
                        usageBreakdown = (List)input.read(new TypeToken<List<UsageForType>>(){}.getType());
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, overrideActive, usageBreakdown);
        }
    }
}

