/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.page.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v113.page.model.ScreencastFrameMetadata;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ScreencastFrame {
    private final String data;
    private final ScreencastFrameMetadata metadata;
    private final Integer sessionId;

    public ScreencastFrame(String data, ScreencastFrameMetadata metadata, Integer sessionId) {
        this.data = Objects.requireNonNull(data, "data is required");
        this.metadata = Objects.requireNonNull(metadata, "metadata is required");
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId is required");
    }

    public String getData() {
        return this.data;
    }

    public ScreencastFrameMetadata getMetadata() {
        return this.metadata;
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    private static ScreencastFrame fromJson(JsonInput input) {
        String data = null;
        ScreencastFrameMetadata metadata = null;
        Integer sessionId = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "data": {
                    data = input.nextString();
                    continue block10;
                }
                case "metadata": {
                    metadata = (ScreencastFrameMetadata)input.read(ScreencastFrameMetadata.class);
                    continue block10;
                }
                case "sessionId": {
                    sessionId = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScreencastFrame(data, metadata, sessionId);
    }
}

