package org.openqa.selenium.devtools.v113.headlessexperimental.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Encoding options for a screenshot.
 */
public class ScreenshotParams {

    public enum Format {

        JPEG("jpeg"), PNG("png"), WEBP("webp");

        private String value;

        Format(String value) {
            this.value = value;
        }

        public static Format fromString(String s) {
            return java.util.Arrays.stream(Format.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Format "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Format fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final java.util.Optional<Format> format;

    private final java.util.Optional<java.lang.Integer> quality;

    private final java.util.Optional<java.lang.Boolean> optimizeForSpeed;

    public ScreenshotParams(java.util.Optional<Format> format, java.util.Optional<java.lang.Integer> quality, java.util.Optional<java.lang.Boolean> optimizeForSpeed) {
        this.format = format;
        this.quality = quality;
        this.optimizeForSpeed = optimizeForSpeed;
    }

    /**
     * Image compression format (defaults to png).
     */
    public java.util.Optional<Format> getFormat() {
        return format;
    }

    /**
     * Compression quality from range [0..100] (jpeg only).
     */
    public java.util.Optional<java.lang.Integer> getQuality() {
        return quality;
    }

    /**
     * Optimize image encoding for speed, not for resulting size (defaults to false)
     */
    public java.util.Optional<java.lang.Boolean> getOptimizeForSpeed() {
        return optimizeForSpeed;
    }

    private static ScreenshotParams fromJson(JsonInput input) {
        java.util.Optional<Format> format = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> quality = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> optimizeForSpeed = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "format":
                    format = java.util.Optional.ofNullable(Format.fromString(input.nextString()));
                    break;
                case "quality":
                    quality = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "optimizeForSpeed":
                    optimizeForSpeed = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScreenshotParams(format, quality, optimizeForSpeed);
    }
}
