package org.openqa.selenium.devtools.v113.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum indicating the reason a response has been blocked. These reasons are
 * refinements of the net error BLOCKED_BY_RESPONSE.
 */
public enum BlockedByResponseReason {

    COEPFRAMERESOURCENEEDSCOEPHEADER("CoepFrameResourceNeedsCoepHeader"), COOPSANDBOXEDIFRAMECANNOTNAVIGATETOCOOPPAGE("CoopSandboxedIFrameCannotNavigateToCoopPage"), CORPNOTSAMEORIGIN("CorpNotSameOrigin"), CORPNOTSAMEORIGINAFTERDEFAULTEDTOSAMEORIGINBYCOEP("CorpNotSameOriginAfterDefaultedToSameOriginByCoep"), CORPNOTSAMESITE("CorpNotSameSite");

    private String value;

    BlockedByResponseReason(String value) {
        this.value = value;
    }

    public static BlockedByResponseReason fromString(String s) {
        return java.util.Arrays.stream(BlockedByResponseReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within BlockedByResponseReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static BlockedByResponseReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
