package org.openqa.selenium.devtools.v112.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Indicates whether a frame has been identified as an ad and why.
 */
@org.openqa.selenium.Beta()
public class AdFrameStatus {

    private final org.openqa.selenium.devtools.v112.page.model.AdFrameType adFrameType;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v112.page.model.AdFrameExplanation>> explanations;

    public AdFrameStatus(org.openqa.selenium.devtools.v112.page.model.AdFrameType adFrameType, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v112.page.model.AdFrameExplanation>> explanations) {
        this.adFrameType = java.util.Objects.requireNonNull(adFrameType, "adFrameType is required");
        this.explanations = explanations;
    }

    public org.openqa.selenium.devtools.v112.page.model.AdFrameType getAdFrameType() {
        return adFrameType;
    }

    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v112.page.model.AdFrameExplanation>> getExplanations() {
        return explanations;
    }

    private static AdFrameStatus fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v112.page.model.AdFrameType adFrameType = null;
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v112.page.model.AdFrameExplanation>> explanations = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "adFrameType":
                    adFrameType = input.read(org.openqa.selenium.devtools.v112.page.model.AdFrameType.class);
                    break;
                case "explanations":
                    explanations = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v112.page.model.AdFrameExplanation>>() {
                    }.getType()));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AdFrameStatus(adFrameType, explanations);
    }
}
