package org.openqa.selenium.devtools.v112.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * TODO(crbug/1384419): Create a dedicated domain for preloading.
 * Fired when a prerender attempt is updated.
 */
@org.openqa.selenium.Beta()
public class PrerenderStatusUpdated {

    private final org.openqa.selenium.devtools.v112.page.model.FrameId initiatingFrameId;

    private final java.lang.String prerenderingUrl;

    private final org.openqa.selenium.devtools.v112.page.model.PreloadingStatus status;

    public PrerenderStatusUpdated(org.openqa.selenium.devtools.v112.page.model.FrameId initiatingFrameId, java.lang.String prerenderingUrl, org.openqa.selenium.devtools.v112.page.model.PreloadingStatus status) {
        this.initiatingFrameId = java.util.Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = java.util.Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.status = java.util.Objects.requireNonNull(status, "status is required");
    }

    /**
     * The frame id of the frame initiating prerender.
     */
    public org.openqa.selenium.devtools.v112.page.model.FrameId getInitiatingFrameId() {
        return initiatingFrameId;
    }

    public java.lang.String getPrerenderingUrl() {
        return prerenderingUrl;
    }

    public org.openqa.selenium.devtools.v112.page.model.PreloadingStatus getStatus() {
        return status;
    }

    private static PrerenderStatusUpdated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v112.page.model.FrameId initiatingFrameId = null;
        java.lang.String prerenderingUrl = null;
        org.openqa.selenium.devtools.v112.page.model.PreloadingStatus status = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "initiatingFrameId":
                    initiatingFrameId = input.read(org.openqa.selenium.devtools.v112.page.model.FrameId.class);
                    break;
                case "prerenderingUrl":
                    prerenderingUrl = input.nextString();
                    break;
                case "status":
                    status = input.read(org.openqa.selenium.devtools.v112.page.model.PreloadingStatus.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrerenderStatusUpdated(initiatingFrameId, prerenderingUrl, status);
    }
}
