/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.domsnapshot;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.v110.domsnapshot.model.ComputedStyle;
import org.openqa.selenium.devtools.v110.domsnapshot.model.DOMNode;
import org.openqa.selenium.devtools.v110.domsnapshot.model.DocumentSnapshot;
import org.openqa.selenium.devtools.v110.domsnapshot.model.LayoutTreeNode;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DOMSnapshot {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOMSnapshot.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOMSnapshot.enable", (Map)params.build());
    }

    @Deprecated
    public static Command<GetSnapshotResponse> getSnapshot(List<String> computedStyleWhitelist, Optional<Boolean> includeEventListeners, Optional<Boolean> includePaintOrder, Optional<Boolean> includeUserAgentShadowTree) {
        Objects.requireNonNull(computedStyleWhitelist, "computedStyleWhitelist is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"computedStyleWhitelist", computedStyleWhitelist);
        includeEventListeners.ifPresent(p -> params.put((Object)"includeEventListeners", p));
        includePaintOrder.ifPresent(p -> params.put((Object)"includePaintOrder", p));
        includeUserAgentShadowTree.ifPresent(p -> params.put((Object)"includeUserAgentShadowTree", p));
        return new Command("DOMSnapshot.getSnapshot", (Map)params.build(), input -> (GetSnapshotResponse)input.read(GetSnapshotResponse.class));
    }

    public static Command<CaptureSnapshotResponse> captureSnapshot(List<String> computedStyles, Optional<Boolean> includePaintOrder, Optional<Boolean> includeDOMRects, Optional<Boolean> includeBlendedBackgroundColors, Optional<Boolean> includeTextColorOpacities) {
        Objects.requireNonNull(computedStyles, "computedStyles is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"computedStyles", computedStyles);
        includePaintOrder.ifPresent(p -> params.put((Object)"includePaintOrder", p));
        includeDOMRects.ifPresent(p -> params.put((Object)"includeDOMRects", p));
        includeBlendedBackgroundColors.ifPresent(p -> params.put((Object)"includeBlendedBackgroundColors", p));
        includeTextColorOpacities.ifPresent(p -> params.put((Object)"includeTextColorOpacities", p));
        return new Command("DOMSnapshot.captureSnapshot", (Map)params.build(), input -> (CaptureSnapshotResponse)input.read(CaptureSnapshotResponse.class));
    }

    public static class CaptureSnapshotResponse {
        private final List<DocumentSnapshot> documents;
        private final List<String> strings;

        public CaptureSnapshotResponse(List<DocumentSnapshot> documents, List<String> strings) {
            this.documents = Objects.requireNonNull(documents, "documents is required");
            this.strings = Objects.requireNonNull(strings, "strings is required");
        }

        public List<DocumentSnapshot> getDocuments() {
            return this.documents;
        }

        public List<String> getStrings() {
            return this.strings;
        }

        private static CaptureSnapshotResponse fromJson(JsonInput input) {
            List documents = null;
            List strings = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "documents": {
                        documents = (List)input.read(new TypeToken<List<DocumentSnapshot>>(){}.getType());
                        continue block8;
                    }
                    case "strings": {
                        strings = (List)input.read(new TypeToken<List<String>>(){}.getType());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CaptureSnapshotResponse(documents, strings);
        }
    }

    public static class GetSnapshotResponse {
        private final List<DOMNode> domNodes;
        private final List<LayoutTreeNode> layoutTreeNodes;
        private final List<ComputedStyle> computedStyles;

        public GetSnapshotResponse(List<DOMNode> domNodes, List<LayoutTreeNode> layoutTreeNodes, List<ComputedStyle> computedStyles) {
            this.domNodes = Objects.requireNonNull(domNodes, "domNodes is required");
            this.layoutTreeNodes = Objects.requireNonNull(layoutTreeNodes, "layoutTreeNodes is required");
            this.computedStyles = Objects.requireNonNull(computedStyles, "computedStyles is required");
        }

        public List<DOMNode> getDomNodes() {
            return this.domNodes;
        }

        public List<LayoutTreeNode> getLayoutTreeNodes() {
            return this.layoutTreeNodes;
        }

        public List<ComputedStyle> getComputedStyles() {
            return this.computedStyles;
        }

        private static GetSnapshotResponse fromJson(JsonInput input) {
            List domNodes = null;
            List layoutTreeNodes = null;
            List computedStyles = null;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "domNodes": {
                        domNodes = (List)input.read(new TypeToken<List<DOMNode>>(){}.getType());
                        continue block10;
                    }
                    case "layoutTreeNodes": {
                        layoutTreeNodes = (List)input.read(new TypeToken<List<LayoutTreeNode>>(){}.getType());
                        continue block10;
                    }
                    case "computedStyles": {
                        computedStyles = (List)input.read(new TypeToken<List<ComputedStyle>>(){}.getType());
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetSnapshotResponse(domNodes, layoutTreeNodes, computedStyles);
        }
    }
}

