/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v109.network.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ConnectionType {
    NONE("none"),
    CELLULAR2G("cellular2g"),
    CELLULAR3G("cellular3g"),
    CELLULAR4G("cellular4g"),
    BLUETOOTH("bluetooth"),
    ETHERNET("ethernet"),
    WIFI("wifi"),
    WIMAX("wimax"),
    OTHER("other");

    private String value;

    private ConnectionType(String value) {
        this.value = value;
    }

    public static ConnectionType fromString(String s) {
        return Arrays.stream(ConnectionType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ConnectionType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ConnectionType fromJson(JsonInput input) {
        return ConnectionType.fromString(input.nextString());
    }
}

