package org.openqa.selenium.devtools.v109.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information about a signed exchange response.
 */
@org.openqa.selenium.Beta()
public class SignedExchangeError {

    private final java.lang.String message;

    private final java.util.Optional<java.lang.Integer> signatureIndex;

    private final java.util.Optional<org.openqa.selenium.devtools.v109.network.model.SignedExchangeErrorField> errorField;

    public SignedExchangeError(java.lang.String message, java.util.Optional<java.lang.Integer> signatureIndex, java.util.Optional<org.openqa.selenium.devtools.v109.network.model.SignedExchangeErrorField> errorField) {
        this.message = java.util.Objects.requireNonNull(message, "message is required");
        this.signatureIndex = signatureIndex;
        this.errorField = errorField;
    }

    /**
     * Error message.
     */
    public java.lang.String getMessage() {
        return message;
    }

    /**
     * The index of the signature which caused the error.
     */
    public java.util.Optional<java.lang.Integer> getSignatureIndex() {
        return signatureIndex;
    }

    /**
     * The field which caused the error.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v109.network.model.SignedExchangeErrorField> getErrorField() {
        return errorField;
    }

    private static SignedExchangeError fromJson(JsonInput input) {
        java.lang.String message = null;
        java.util.Optional<java.lang.Integer> signatureIndex = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v109.network.model.SignedExchangeErrorField> errorField = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "message":
                    message = input.nextString();
                    break;
                case "signatureIndex":
                    signatureIndex = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "errorField":
                    errorField = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v109.network.model.SignedExchangeErrorField.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SignedExchangeError(message, signatureIndex, errorField);
    }
}
