package org.openqa.selenium.devtools.v108.browser.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Browser window bounds information
 */
@org.openqa.selenium.Beta()
public class Bounds {

    private final java.util.Optional<java.lang.Integer> left;

    private final java.util.Optional<java.lang.Integer> top;

    private final java.util.Optional<java.lang.Integer> width;

    private final java.util.Optional<java.lang.Integer> height;

    private final java.util.Optional<org.openqa.selenium.devtools.v108.browser.model.WindowState> windowState;

    public Bounds(java.util.Optional<java.lang.Integer> left, java.util.Optional<java.lang.Integer> top, java.util.Optional<java.lang.Integer> width, java.util.Optional<java.lang.Integer> height, java.util.Optional<org.openqa.selenium.devtools.v108.browser.model.WindowState> windowState) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.windowState = windowState;
    }

    /**
     * The offset from the left edge of the screen to the window in pixels.
     */
    public java.util.Optional<java.lang.Integer> getLeft() {
        return left;
    }

    /**
     * The offset from the top edge of the screen to the window in pixels.
     */
    public java.util.Optional<java.lang.Integer> getTop() {
        return top;
    }

    /**
     * The window width in pixels.
     */
    public java.util.Optional<java.lang.Integer> getWidth() {
        return width;
    }

    /**
     * The window height in pixels.
     */
    public java.util.Optional<java.lang.Integer> getHeight() {
        return height;
    }

    /**
     * The window state. Default to normal.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v108.browser.model.WindowState> getWindowState() {
        return windowState;
    }

    private static Bounds fromJson(JsonInput input) {
        java.util.Optional<java.lang.Integer> left = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> top = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> width = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> height = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v108.browser.model.WindowState> windowState = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "left":
                    left = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "top":
                    top = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "width":
                    width = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "height":
                    height = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "windowState":
                    windowState = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v108.browser.model.WindowState.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Bounds(left, top, width, height, windowState);
    }
}
