package org.openqa.selenium.devtools.v108.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum IPAddressSpace {

    LOCAL("Local"), PRIVATE("Private"), PUBLIC("Public"), UNKNOWN("Unknown");

    private String value;

    IPAddressSpace(String value) {
        this.value = value;
    }

    public static IPAddressSpace fromString(String s) {
        return java.util.Arrays.stream(IPAddressSpace.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within IPAddressSpace "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static IPAddressSpace fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
