package org.openqa.selenium.devtools.v106.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Represents the value serialiazed by the WebDriver BiDi specification
 * https://w3c.github.io/webdriver-bidi.
 */
public class WebDriverValue {

    public enum Type {

        UNDEFINED("undefined"),
        NULL("null"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        BIGINT("bigint"),
        REGEXP("regexp"),
        DATE("date"),
        SYMBOL("symbol"),
        ARRAY("array"),
        OBJECT("object"),
        FUNCTION("function"),
        MAP("map"),
        SET("set"),
        WEAKMAP("weakmap"),
        WEAKSET("weakset"),
        ERROR("error"),
        PROXY("proxy"),
        PROMISE("promise"),
        TYPEDARRAY("typedarray"),
        ARRAYBUFFER("arraybuffer"),
        NODE("node"),
        WINDOW("window");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return java.util.Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Type fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Type type;

    private final java.util.Optional<java.lang.Object> value;

    private final java.util.Optional<java.lang.String> objectId;

    public WebDriverValue(Type type, java.util.Optional<java.lang.Object> value, java.util.Optional<java.lang.String> objectId) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.value = value;
        this.objectId = objectId;
    }

    public Type getType() {
        return type;
    }

    public java.util.Optional<java.lang.Object> getValue() {
        return value;
    }

    public java.util.Optional<java.lang.String> getObjectId() {
        return objectId;
    }

    private static WebDriverValue fromJson(JsonInput input) {
        Type type = null;
        java.util.Optional<java.lang.Object> value = java.util.Optional.empty();
        java.util.Optional<java.lang.String> objectId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = Type.fromString(input.nextString());
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.read(Object.class));
                    break;
                case "objectId":
                    objectId = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new WebDriverValue(type, value, objectId);
    }
}
